<!doctype html>
<html class="no-js" <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width,initial-scale=1.0,minimum-scale=1">
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?> itemscope="itemscope" itemtype="https://schema.org/WebPage">
	<?php wp_body_open(); ?>
	<div class="site">
		<?php
		/**
		 * talemy_before_page hook.
		 */
		do_action( 'talemy_before_page' );
		?>
		<div class="site-main">
			<?php
			/**
			 * talemy_before_header hook.
			 */
			do_action( 'talemy_before_header' );

			/**
			 * talemy_header hook.
			 *
			 * @hooked talemy_output_header - 10
			 */
			do_action( 'talemy_header' );

			/**
			 * talemy_after_header hook.
			 */
			do_action( 'talemy_after_header' );

			/**
			 * talemy_content_start hook.
			 * 
			 * @hooked talemy_output_content_header - 10
			 * @hooked talemy_output_content_wrapper_start - 10
			 */
			do_action( 'talemy_before_content' );
