(function($) {
    'use strict';

    var $window = $(window);

    var loader = {
        elem: null,
        loading: true,
        width: 0,
        maxWidth: 400,

        init: function() {
            loader.elem = $('#loader');

            if (loader.elem.length === 0) {
                return;
            }

            if ($window.width() < 480) {
                loader.maxWidth = 100;
            } else {
                loader.maxWidth = 400;
            }

            switch(loader.elem.attr('class')) {
                case 'line': loader.line(); break;
                default: loader.spinner(); break;
            }
        },

        line: function() {
            
            loader.elem.css({ top: $window.height() / 2 - 1, left: $window.width() / 2 - loader.maxWidth / 2 });
            loader.progress();

            $window.on('load', function() {
                setTimeout(function() {
                    loader.loading = false;
                    loader.elem.stop(true);
                    loader.elem.animate({ left: 0, width: '100%' })
                    // loader.elem.animate({ top: '0', height: '100vh' })
                    loader.elem.fadeOut(100);
                    loader.elem.promise().done(function() {
                        $('body').removeClass('page-loading');
                    });
                }, 200);
            });
        },

        spinner: function() {
            $window.on('load', function() {
                setTimeout(function() {
                    loader.elem.fadeOut(100);
                    loader.elem.promise().done(function() {
                        $('body').removeClass('page-loading');
                    });
                }, 200);
            });
        },

        progress: function() {
            if (loader.loading && loader.width < loader.maxWidth) {
                loader.width += 3;
                loader.elem.animate({ width: loader.width }, 10);
                loader.progress();
            }
        }
    }

    loader.init();

    /**
     * Remove no-js class
     */
     document.documentElement.className = document.documentElement.className.replace('no-js', 'js');
    
    /**
     * WordPress admin bar
     */
    var wpadminbar = {

        enabled: false,
        fixed: false,
        height: 0,

        init: function() {
            var adminbar = $('#wpadminbar');
            if (adminbar.length) {
                this.enabled = true;
                this.height = adminbar.height();
                if (adminbar.css('position') === 'fixed') {
                    this.fixed = true;
                } else {
                    this.fixed = false;
                }
            } else {
                this.enabled = false;
                this.height = 0; 
            }
        },
    };

    function matchMaxWidth(width) {
        var matchMedia = window.matchMedia || window.msMatchMedia;
        if (matchMedia) {
            var mql = matchMedia('(max-width:' + width + 'px)');
            return mql && mql.matches || false;
        } else {
            return ($window.width() < width);
        }
    }

    function matchMinWidth(width) {
        var matchMedia = window.matchMedia || window.msMatchMedia;
        if (matchMedia) {
            var mql = matchMedia('(min-width:' + width + 'px)');
            return mql && mql.matches || false;
        } else {
            return ($window.width() >= width);
        }
    }
    
    function cssTranslate3d(elem, value) {
        var translate3d = 'translate3d(0,' + value + 'px, 0)';
        elem.style['-webkit-transform'] = translate3d;
        elem.style['-moz-transform'] = translate3d;
        elem.style['-ms-transform'] = translate3d;
        elem.style['-o-transform'] = translate3d;
        elem.style.transform = translate3d;
    }

    /* -----------------------------------------------------------------------------
     * Common features
     * ----------------------------------------------------------------------------- */
    function commonFeatures() {
        // Post gallery
        Slider($('.post-gallery'));
        
        // Selectric
        $('.woocommerce-ordering .orderby,.product .variations select,.widget_archive select,.widget_text select,.wpcf7-form select,.course-search-category,.course-search-tag,.content-search select,#tinvwl_product_actions,.sf-register-form select').selectric();

        // Scroll top
        $('.scroll-top').on('click touchend', function(e) {
            e.preventDefault();
            $('html,body').animate({ scrollTop: 0 }, 400);
        });

        var scrollButton = $('#scroll-top');
        var scrollButtonVisible = false;

        $window.on('scroll', $.throttle(100, function() {
            if ($window.scrollTop() > 200) {
                if (!scrollButtonVisible) {
                    scrollButton.addClass('active');
                    scrollButtonVisible = true;
                }
            } else {
                if (scrollButtonVisible) {
                    scrollButton.removeClass('active');
                    scrollButtonVisible = false;
                }
            }
        }));

        // infinite scroll & load more
        var ajaxLoader = $('div.ajax-loader');
        if (ajaxLoader.length) {
            ajaxPosts.init(ajaxLoader);
        }

        // Hamburger
        $(document).on('click touchend', '.hamburger,.hamburger-2', function(e) {
            e.preventDefault();

            if ($(this).hasClass('hamburger')) {
                $('body').toggleClass('off-canvas-left-active');
            } else {
                $('body').toggleClass('off-canvas-right-active');
            }
        });

        $('.off-canvas-close').on('click touchend', function(e) {
            e.preventDefault();
            $('body').removeClass('off-canvas-left-active off-canvas-right-active');
        });

        $('.site-overlay').on('touchstart click', function(e) {
            e.preventDefault();
            $('body').removeClass('off-canvas-left-active off-canvas-right-active');
        });


        $('.btn-search').on('click', function(e) {
            e.preventDefault();

            if (!$('body').hasClass('nav-sf-active')) {
                $('body').addClass('nav-sf-active');
                setTimeout(function() {
                    $('.nav-sf-input').focus();
                }, 200);
            } else {
                $('body').removeClass('nav-sf-active');
            }
        });

        /**
         * Ajax Search
         */
        var xhr = null;
        $(document).on('keyup paste', '.ajax-search-form input[type=search]', $.debounce(200, function() {
            var $formInput = $(this);
            var $form = $formInput.closest('form');
            var $inputParent = $formInput.parent();
            var $results = $form.find('.ajax-search-results');
            var $loader = $form.find('.ajax-search-loader');
            var query = $formInput.val();

            if ($results.length === 0) {
                $inputParent.append('<div class="ajax-search-results"></div>');
                $results = $inputParent.find('.ajax-search-results');
            }
 
            if ($loader.length === 0) {
                $inputParent.append('<div class="ajax-search-loader"></div>');
                $loader = $inputParent.find('.ajax-search-loader');
            }

            if (query === '') { // if query is empty
                $loader.hide();
                if (xhr !== null) {
                    xhr.abort(); // abort ajax request
                }
                $results.empty();
            
            } else if ($.trim(query) === '') { // if query contains only white space
                $results.empty();

            } else {
                $results.empty();
                $loader.show();

                xhr = $.ajax({
                    type: 'POST',
                    url: talemy_js_data.ajax_url,
                    data:({
                        action: 'talemy_ajax_search',
                        query: query,
                        form: $form.serialize()
                    }),
                    timeout: 8000,
                    success: function(data) {
                        $loader.hide();
                        if (!$results.is(':empty')) {
                            $results.empty();
                        }
                        $results.append(data);
                    },
                    error: function(x, t, m) {
                        if (t === 'timeout') {
                            $loader.hide();
                            if (!$results.is(':empty')) {
                                $results.empty();
                            }
                            $results.append('<p style="text-align: center;">Request Timeout.</p>');
                        }
                    }
                });
            }

        }));

        $(document).on('click', '.clear-input', function(e) {
            var $form = $(this).closest('form');
            var $results = $form.find('.ajax-search-results');
            $form.find('input[type=search]').val('').focus();
            $results.empty();
            $(this).hide();
        });

        $(document).on('click touchstart', '.dropdown-on-hover .btn-has-dropdown', function(e) {
            e.preventDefault();
            $(this).parent().toggleClass('active');
            return false;
        });

        $(document).on('click', '.focus-sidebar__toggle', function(e) {
            e.preventDefault();
            var $focusWrapper = $(this).closest('.course-focus');
            $focusWrapper.toggleClass('focus-sidebar-active');
        });

        // side menu
        $('.off-canvas-menu a')
            .filter(function() {
                var a = $(this);
                return a.parent().hasClass('menu-item-has-children') && (a.attr('href') === '#' || typeof a.attr('href') === 'undefined');
            })
            .add('.off-canvas-menu .menu-expand')
            .bind('click touchend', function(e) {
                e.preventDefault();
                var menuItem = $(this).parent();
                
                if (!menuItem.hasClass('active')) {
                    menuItem.addClass('active');
                    menuItem.find('>ul').slideDown('fast');
                    
                    if (menuItem.parent().hasClass('side-menu')) {
                        $('.off-canvas-menu li.active').each(function() {
                            var $this = $(this);
                            
                            if (!$this.is(menuItem)) {
                                $(this).removeClass('active');
                                $(this).find('>ul').slideUp('fast');
                            }
                        });
                    }
                } else {
                    menuItem.find('>ul').slideUp('fast');
                    menuItem.removeClass('active');
                }
            });


        // Woocommerce quantity +/- buttons
        var wooProduct = null;

        $(document.body)

            .on('click', '.ajax_add_to_cart', function() {
                wooProduct = $(this).parents('.product');
                wooProduct.addClass('adding_to_cart');
            })

            .on('added_to_cart', function() {
                if (wooProduct !== null) {
                    wooProduct.removeClass('adding_to_cart').addClass('added_to_cart');
                    wooProduct = null;
                }
            })

            .on('click', 'input.plus, input.minus', function() {
                var qty = $(this).siblings('.qty');
                var val = parseFloat(qty.val());
                var max = parseFloat(qty.attr('max'));
                var min = parseFloat(qty.attr('min'));
                var step = qty.attr('step');

                if (val === '' || isNaN(val)) val = 1;
                if (max === '' || isNaN(max)) max = '';
                if (min === '' || isNaN(min)) min = 1;
                if (step === '' || step === 'any' || isNaN(parseFloat(step))) step = 1;

                if ($(this).is('.plus')) {
                    if (max && val >= max) {
                        qty.val(max);
                    } else {
                        qty.val(val + parseFloat(step));
                    }
                } else {
                    if (min && val <= min) {
                        qty.val(min);
                    } else if (val > 1) {
                        qty.val(val - parseFloat(step));
                    }
                }
                qty.trigger('change');

            })
            
            .on('click', '.reset_variations', function() {
                    var form = $(this).closest('.variations');
                    form.find('select').prop('selectedIndex', 0).selectric('refresh');
            });

        // account dropdown
        $('.nav-logged-in').superfish({
            animation: {opacity:'show'},
            cssArrows: false,
            delay: 0,
            disableHI: true,
            popUpSelector: '.account-dropdown',
            speed: 'fast',
            speedOut: 0,
            onBeforeShow: function(e) {
                var left = $(window).width() - $(this).prev().offset().left;
                if (left < 160) {
                    $(this).css({
                        'left': 'auto',
                        'right': '0'
                    });
                }
            }
        });

        // nav course categories
        $('.nav-category-list').superfish({
            animation: {opacity:'show'},
            cssArrows: false,
            delay: 0,
            disableHI: true,
            popUpSelector: '.course-category-list',
            speed: 'fast',
            speedOut: 0,
        });

        $(document).on('click', '.course-tab[href="#course-section__curriculum"]', function() {
            setTimeout(function() {
                $(window).trigger('resize');
            }, 100);
        });

        $('.course-section__title').on('click', function(e) {
            e.preventDefault();
            var $title = $(this);
            var $activeTitle = $title.siblings('.active');
            
            if (!$title.hasClass('active')) {
                $title.addClass('active');
                $title.next().slideDown();
            } else {
                $title.removeClass('active');
                $title.next().slideUp();
            }

            if ($activeTitle.length) {
                $activeTitle.removeClass('active');
                $activeTitle.next().slideUp();
            }
        });

        $('.course-section__title:first-child').click();

        $('#course-sidebar__share-btn').on('click', function(e) {
            e.preventDefault();
            $(this).siblings('.post-share').slideToggle();
        });

        $(document).on('click', '.to-llms-access-plans', function(e) {
            e.preventDefault();
            var accessPlans = $('.llms-access-plan');
            if ( accessPlans.length ) {
                $('html,body').animate({ scrollTop: accessPlans.offset().top - 60 }, 400);
            }
        })

        // BuddyPress
        if ($('body').hasClass('buddypress')) {
            $('#group-members-role-filter,.select-wrap select').selectric();

            $('#whats-new-form').on('click', function() {
                $('#whats-new-post-in').selectric();
            });

            $(document).ajaxSuccess(function() {
                setTimeout(function() {
                    $('.select-wrap select').selectric();
                }, 600);
            });
        }

        // Popover positioning
        popoverPosition();

        // Move course sidebar
        moveCourseSidebar();

        // Nav Buttons
        navButtons();
    }

    /* -----------------------------------------------------------------------------
     * Course Sidebar
     * ----------------------------------------------------------------------------- */
    function moveCourseSidebar() {
        if (matchMaxWidth(1024) && $('.course-sidebar').length) {
            $('.course-intro__content').after($('.course-sidebar'));
        } else {
            $('.course-sidebar').prependTo($('.sidebar-inner'));
        }
    }

    /* -----------------------------------------------------------------------------
     * Popover content
     * ----------------------------------------------------------------------------- */
    function popoverPosition() {
        if (matchMinWidth(768)) {
            $(document).on('mouseenter', '.post-body.has-popover', function() {
                var $post = $(this);
                var $popover = $(this).find('.post-popover');
                var postOffset = $post.offset();
                var popoverClass = 'popover-right';
                var popoverHeight = $popover.outerHeight();
                var offset = popoverHeight - $post.outerHeight();
                // center popover content if its height is greater than post height
                offset = offset > 0 ? offset/2 : 0;
                var top = postOffset.top - $(window).scrollTop() - offset;
                var left = 0;


                if (top < 0) {
                    top = Math.abs(top) + wpadminbar.height - offset;
                } else if (top + popoverHeight > $window.height()) {
                    top = - (top + popoverHeight - $window.height() + offset);
                } else {
                    top = offset > 0 ? offset*-1 : 0;
                }

                if (postOffset.left + $post.width() + $popover.outerWidth() + 10 > $window.width()) {
                    left = - $popover.outerWidth() - 10;
                    popoverClass = 'popover-left';
                } else {
                    left = $post.width() + 10;
                }

                $popover
                    .css({
                        'top': top + 'px',
                        'left': left + 'px'
                    })
                    .addClass(popoverClass);
            });
        } else {
            $(document).off('mouseenter', '.post-body.has-popover');
        }
    }

    /* -----------------------------------------------------------------------------
     * Sticky Footer
     * ----------------------------------------------------------------------------- */
    function stickyFooter() {
        var minHeight = $window.height() - $('#header').outerHeight() - $('#footer').outerHeight() - wpadminbar.height;
        $('#content').css('min-height', minHeight + 'px');
    }

    /**
     * Course Sidebar
     */
    function courseSidebar() {
        const focusContainer = $('.single-lesson .course-focus');
        if (focusContainer.length) {
            if (matchMaxWidth(1024)) {
                focusContainer.removeClass('focus-sidebar-active');
            } else {
                focusContainer.addClass('focus-sidebar-active');
            }
        }
    }

    /* -----------------------------------------------------------------------------
     * Sticky Sidebar
     * ----------------------------------------------------------------------------- */
    function stickySidebar() {
        var marginTop = 30;
        var $navbar = $('.navbar');

        if (wpadminbar.fixed) {
            marginTop += wpadminbar.height;
        }

        if ( $navbar.length ) {
            var stickySettings = $navbar.data('sticky');
            var stickyMode = stickySettings.sticky || '';
            if ( 'always' === stickyMode ) {
                marginTop += $navbar.outerHeight();
            }
        }

        $('.sidebar.sticky').each(function() {
            $(this).theiaStickySidebar({
                containerSelector: $(this).parents('.row'),
                additionalMarginTop: marginTop,
                additionalMarginBottom: 20
            });
        });

        $('.sticky-sidebar').each(function() {
            $(this).theiaStickySidebar({
                containerSelector: $(this).parents('.row'),
                additionalMarginTop: marginTop,
                additionalMarginBottom: 20
            });
        });
    }

    /**
     * Sticky navigation
     */
    var sticky_defaults = {
        sticky: '',
        sticky_on: ['desktop', 'tablet', 'mobile'],
        breakpoints: {
            tablet: 1025,
            mobile: 768
        },
        stickyClass: 'nav-is-fixed',
        stickySidebarClass: '.sticky-sidebar .sidebar-inner'
    }

    function Sticky(element, options) {
        this.$element = $(element);
        this.settings = $.extend({}, sticky_defaults, options);
        this.initialized = false;
        this.settings.breakpoints.tablet = parseInt(this.settings.breakpoints.tablet);
        this.settings.breakpoints.mobile = parseInt(this.settings.breakpoints.mobile);
        this.offsetTop = 0;
        this.lastScroll = 0;
        this.isMaxY = false;
        this.isMinY = true;
        this.transformY = 0;
        this.stickySidebarClass = '.sidebar-inner';
        this.$stickySidebar = $(this.settings.stickySidebarClass);
        this.init();
    }

    $.extend(Sticky.prototype, {

        init: function () {
            var base = this;
            var scrollhandler;

            if (base.settings.sticky != 'always' && base.settings.sticky != 'smart') {
                return;
            }

            this._reset();

            if ('always' === base.settings.sticky) {
                scrollhandler = function () {
                    base.always(base.$element);
                }
            } else if ('smart' === base.settings.sticky) {
                scrollhandler = function () {
                    base.smart(base.$element);
                }
            }

            if (base.settings.sticky_on.indexOf(base.getDeviceMode()) !== -1) {
                window.addEventListener('scroll', scrollhandler, false);
                base.initialized = true;
            }

            if (this.$stickySidebar.length) {
                this.sidebarOffsetTop = this.$stickySidebar.offset().top;
            }

            $window.on('resize orientationchange', $.debounce(200, function () {

                if (base.settings.sticky_on.indexOf(base.getDeviceMode()) === -1) {
                    if (base.initialized) {
                        window.removeEventListener('scroll', scrollhandler, false);
                        base._reset();
                        base.initialized = false;
                    }
                    return;
                }

                base._reset();

                if (!base.initialized) {
                    window.addEventListener('scroll', scrollhandler, false);
                    base.initialized = true;
                }

                scrollhandler();
            }));
        },

        getDeviceMode: function () {
            if (matchMinWidth(this.settings.breakpoints.tablet)) {
                return 'desktop';
            } else if (matchMinWidth(this.settings.breakpoints.mobile)) {
                return 'tablet';
            } else {
                return 'mobile';
            }
        },

        _reset: function () {
            this.$element.removeClass(this.settings.stickyClass).css('top', '').attr('style', '');
            this.$element.parent().css('min-height', this.$element.outerHeight());
            this.offsetTop = this.$element.parent().offset().top - wpadminbar.height;
        },

        always: function (element) {
            var currentScroll = $window.scrollTop();

            if (wpadminbar.enabled && wpadminbar.fixed || $window.scrollTop() === 0) {
                element.css('top', wpadminbar.height + 'px');
            } else {
                element.css('top', '0');
            }

            if (currentScroll > this.offsetTop) {
                if (!element.hasClass(this.settings.stickyClass)) {
                    element.addClass(this.settings.stickyClass);
                }
            } else {
                element.removeClass(this.settings.stickyClass);
            }
        },

        smart: function (element) {
            var currentScroll = $window.scrollTop();
            var scrollDistance = currentScroll - this.lastScroll; // scroll distance
            var y = this.transformY;
            var navheight = element.outerHeight();
            var stickySidebarOn = false;

            if (this.$stickySidebar.length) {
                var $stickySidebar = this.$stickySidebar;
                var sidebarOffsetTop = this.sidebarOffsetTop;
                stickySidebarOn = true;
            }

            if (wpadminbar.enabled && (wpadminbar.fixed || currentScroll === 0)) {
                element.css('top', wpadminbar.height + 'px');
            } else {
                element.css('top', '0');
            }

            if (currentScroll > this.offsetTop) {
                if (!element.hasClass(this.settings.stickyClass)) {
                    element.addClass(this.settings.stickyClass);
                }

                // scroll down
                if (scrollDistance > 0 && !this.isMaxY) {
                    y -= scrollDistance;

                    if (y < -1 * navheight || y == -1 * navheight) {
                        y = -1 * navheight;
                        this.isMaxY = true;
                        if (!element.hasClass(this.settings.stickyClass)) {
                            element.addClass(this.settings.stickyClass);
                        }
                    }

                    requestAnimationFrame(function () {
                        cssTranslate3d(element[0], y);

                        if (stickySidebarOn && currentScroll > sidebarOffsetTop) {
                            cssTranslate3d($stickySidebar[0], navheight + y);
                        }
                     
                    });

                    this.isMinY = false;

                // scroll up
                } else if (scrollDistance < 0 && !this.isMinY) {
                    y += -1 * scrollDistance;

                    if (y > 0 || y === 0) {
                        y = 0;
                        this.isMinY = true;
                    }

                    requestAnimationFrame(function () {
                        cssTranslate3d(element[0], y);

                        if (stickySidebarOn && currentScroll > sidebarOffsetTop) {
                            cssTranslate3d($stickySidebar[0], navheight + y);
                        }
                    });

                    this.isMaxY = false;
                }

            } else if (currentScroll <= this.offsetTop) {
                element.removeClass(this.settings.stickyClass);
                requestAnimationFrame(function () {
                    cssTranslate3d(element[0], 0);
                });
            }
            
            if (stickySidebarOn && currentScroll <= sidebarOffsetTop - navheight) {
                cssTranslate3d($stickySidebar[0], 0);
            }

            this.transformY = y;
            this.lastScroll = currentScroll;
        },
    });

    $.fn['stickyNavbar'] = function (options) {
        return this.each(function () {
            if (!$.data(this, 'site_sticky_element')) {
                var dataOptions = $(this).data('sticky');
                options = typeof dataOptions === 'object' ? dataOptions : options;
                $.data(this, 'site_sticky_element', new Sticky(this, options));
            }
        });
    };

    /* -----------------------------------------------------------------------------
     * Main Menu
     * ----------------------------------------------------------------------------- */
    var navigation = {

        menu: null,
        submenu: null,
        megamenu: null,
        container: null,
        width: 0,
        space: 0,
        cache: null,

        init: function() {
            var menu = $('.nav-menu');

            if (menu.length === 0) {
                return;
            }

            navigation.menu = menu;
            navigation.cache = menu.html();
            navigation.container = menu.parents('.nav');
            navigation.compress();

            navigation.submenu = menu.find('.sub-menu');
            navigation.megamenu = menu.find('.megamenu-custom-width .megamenu');

            if (navigation.submenu.length) {
                navigation.hovershift();
            }

            if (navigation.megamenu.length) {
                navigation.rePosition();
            }

            navigation.sfmenu();

            $(window).on('resize orientationchange', $.debounce(200, function() {
                navigation.refresh();
            }));
        },

        disableMenus: function() {
            navigation.moreItemsUl.find('.megamenu').each(function() {
                $(this).removeClass('megamenu').addClass('sub-menu');
            })
            
            navigation.moreItemsUl.find('.megamenu-submenu').each(function() {
                $(this).removeClass('megamenu-submenu').addClass('sub-menu');
            });

            navigation.moreItemsUl.find('[class^="megamenu-"],[class*=" megamenu-"]').each(function() {
                var oldName = $(this)[0].className;
                var newName = oldName.replace(new RegExp('megamenu', 'g'), 'mm');
                $(this).attr('class', newName);
            });

            navigation.moreItemsUl.find('>.menu-item>a').attr('style', '');
        },

        sfmenu: function() {
            navigation.menu.superfish({
                animation: {opacity:'show'},
                cssArrows: false,
                delay: 0,
                disableHI: true,
                popUpSelector: '.sub-menu,.megamenu',
                speed: 'fast',
                speedOut: 0,
            });
        },

        compress: function() {
            if (!matchMinWidth(768)) {
                return;
            }
            navigation.menu.addClass('pre-compress');
            var containerWidth = navigation.container.width();

            navigation.moreItems = navigation.menu.find('.menu-items-container');
            navigation.moreItemsUl = navigation.moreItems.find('>ul');
            navigation.moreItems.show();
            navigation.moreItemsWidth = navigation.moreItems.outerWidth();
            navigation.moreItems.hide();

            navigation.menuItems = navigation.menu.children().not('.menu-items-container');
            navigation.width = 0;
            
            navigation.container.children().each(function() {
                if ($(this).is('.nav-menu-wrapper') || $(this).is('.nav-menu')) {
                    for (var i = navigation.menuItems.length - 1; i >= 0; i--) {
                        navigation.width += navigation.menuItems.eq(i).outerWidth();
                    }
                } else {
                    navigation.width += $(this).outerWidth();
                }
            });

            if (navigation.width + navigation.space > containerWidth) {
                navigation.container.addClass('nav-compress');
                
                for (var i = navigation.menuItems.length - 1; i >= 0; i--) {
                    var currentMenuItem = navigation.menuItems.eq(i);
                    navigation.width = navigation.width - currentMenuItem.outerWidth();
                    currentMenuItem.prependTo(navigation.moreItemsUl);

                    if (navigation.width + navigation.space + navigation.moreItemsWidth <= containerWidth) {
                        break;
                    }
                }
                navigation.disableMenus();
                navigation.moreItems.show();
            } else {
                navigation.container.removeClass('nav-compress');
            }

            navigation.menu.removeClass('pre-compress');
        },

        hovershift: function() {
            // Submenu open in opposite direction if there's no enough space
            navigation.submenu.each(function() {
                var $this = $(this);
                var submenuLeft = $this.offset().left;
                var submenuRight = $window.width() - submenuLeft - 200;
                if (submenuLeft < 0 || submenuRight < 0) {
                    $this.addClass('hover-shift');
                } else {
                    $this.removeClass('hover-shift');
                }
            });
        },

        rePosition: function() {
            var navWidth = navigation.container.outerWidth();
            var navOffset = navigation.menu.offset().left;

            navigation.megamenu.each(function() {
                var $menu = $(this);
                var $menuParent = $menu.parent();
                var menuOffset = $menuParent.offset().left;
                var menuWidth = $menu.attr('class').slice(-1) * 220 + 30; // get mega menu width setting from megamenu-custom-* class
                menuWidth = menuWidth > navWidth ? navWidth : menuWidth;
                $menu.css('width', menuWidth + 'px');
                
                // center mega menu
                var distance = menuWidth * 0.5 - $menuParent.outerWidth() * 0.5;
                var shiftRight = distance - menuOffset;
                var shiftLeft = menuWidth * 0.5 + $menuParent.outerWidth() * 0.5 + menuOffset - $window.width();
                var cssPropName = $('body').hasClass('rtl') ? 'margin-right' : 'margin-left';
                // left edge
                if (shiftRight >= 0) {
                    $menu.css(cssPropName, -1*(distance - shiftRight - 15) + 'px');
                // right edge
                } else if (shiftLeft >= 0) {
                    $menu.css(cssPropName, (-1*distance - shiftLeft - 15) + 'px');
                // normal
                } else {
                    $menu.css(cssPropName, -1*distance + 'px');
                }
            });
        },

        refresh: function() {
            if (!matchMinWidth(768)) {
                return;
            }

            navigation.menu.superfish('destroy');
            
            if (navigation.cache) {
                navigation.menu.html(navigation.cache);
            }

            navigation.compress();
            navigation.submenu = navigation.menu.find('.sub-menu');
            navigation.megamenu = navigation.menu.find('.megamenu-custom-width .megamenu');

            if (navigation.submenu.length) {
                navigation.hovershift();
            }

            if (navigation.megamenu.length) {
                navigation.rePosition();
            }

            navigation.sfmenu();
        }
    };

    /* -----------------------------------------------------------------------------
     * Masonry
     * ----------------------------------------------------------------------------- */
    var layouts = (function(self) {
        var masonry = $('.masonry');
        var animated = 0;
        var animation;

        self.init = function() {
            if (masonry.length) {
                masonry.imagesLoaded(function() {
                    self.masonry();
                    masonry.children().eq(animated).addClass('animation-bounce-up');
                    animated += 1;
                    oneByOne(masonry.children(), animated);
                });
            }
        };

        self.masonry = function() {
            masonry.isotope({
                itemSelector: '.post',
                transitionDuration: '0',
            });
        };

        function oneByOne(elems, index) {
            animation = setTimeout(function() {
                elems.eq(index).addClass('animation-bounce-up');
                if (index < elems.length - 1) {
                    animated += 1;
                    oneByOne(elems, animated);
                } else {
                    clearTimeout(animation);
                }
            }, 100);
        }

        return self;

    })(layouts || {});

    /* -----------------------------------------------------------------------------
     * Ajax Posts - Load More & Infinite Scroll
     * ----------------------------------------------------------------------------- */
    var ajaxPosts = (function(self) {

        var settings;
        var loader;
        var container;
        var parent;
        var maxPosts;
        var maxLoads;
        var loaded;
        var ppp;
        var ppl;
        var offset;
        var pagination;
        var footerInner;
        var pageNumber = 0;
        var processing = false;
        var dataStatus = true;

        var loadOnScroll = $.debounce(100, function() {
            if (dataStatus && !processing) {
                if ($(this).scrollTop() >= loader.offset().top - $window.height() - offset) {
                    processing = true;
                    pageNumber ++;
                    loaded += ppl;
                    loadPosts();
                }
            }
        });

        function loadPosts() {

            $.ajax({
                url: talemy_js_data.ajax_url,
                type: 'POST',
                data: ({
                    action: 'talemy_ajax_posts',
                    page_number: pageNumber,
                    atts: settings.atts,
                    query_args: settings.query_args,
                }),
                beforeSend: function() {
                    parent.addClass('loading');
                },
                success: function(data) {
                    if (data) {
                        if (settings.atts.list_style == 'masonry') {
                            var $newEls = $(data);
                            container.append($newEls);
                            container.isotope('appended', $newEls);
                            layouts.init();
                        } else {
                            container.append($(data).hide().fadeIn());
                        }
                    }
                }
            })
            .always(function() {
                processing = false;
                parent.removeClass('loading');

                if (maxPosts <= loaded) {
                    parent.addClass('all-loaded');
                    footerInner.show();
                    dataStatus = false;
                    window.removeEventListener('scroll', loadOnScroll);
                } else {
                    if (pagination != 'scroll') {
                        return;
                    }

                    if (pageNumber == maxLoads) {
                        window.removeEventListener('scroll', loadOnScroll);

                        $.ajax({
                            url: talemy_js_data.ajax_url,
                            type: 'POST',
                            data: ({
                                action: 'talemy_ajax_more_button',
                            }),
                            success: function(data) {
                                pagination = 'more';
                                loader.remove();
                                parent.append(data);
                                footerInner.show();
                                parent.find('.load-more').on('click', function() {
                                    if (!processing) {
                                        processing = true;
                                        pageNumber ++;
                                        loaded += ppl;
                                        loadPosts();
                                    }
                                });
                            }
                        });
                    } else {
                        loadOnScroll();
                    }
                }
            });
        }

        self.init = function(ajaxLoader) {
            loader = ajaxLoader;
            container = ajaxLoader.prev();
            parent = ajaxLoader.parent();
            footerInner = $('#footer>div');

            settings = loader.data('list');
            offset = settings.offset;
            pagination = settings.pagination;
            maxPosts = settings.found_posts;
            maxLoads = settings.max_loads;
            loaded = ppp = parseInt(settings.atts.ppp);
            ppl = parseInt(settings.atts.ppl);

            if (ppl === 0 || ppl === '') {
                ppl = 5;
            }
            
            if (typeof maxLoads == 'undefined' || maxLoads === 0) {
                maxLoads = 9999;
            }

            if (typeof offset == 'undefined') {
                offset = 0;
            }

            if (maxPosts > ppp) {

                if (pagination == 'scroll') {
                    footerInner.hide();
                    window.addEventListener('scroll', loadOnScroll, false);
                    loadOnScroll();
                }

                if (pagination == 'more') {
                    loader.find('.load-more').on('click', function() {
                        if (!processing) {
                            processing = true;
                            pageNumber ++;
                            loaded += ppl;
                            loadPosts();
                        }
                    });
                }
            }
        };

        return self;

    })(ajaxPosts || {});

    var courseTabs = {

        tabs: null,
        hash: '',

        init: function() {

            this.tabs = $('.course-tabs');

            if (this.tabs.length === 0) {
                return;
            }

            $(document.body).on('click', '.course-tab', function(e) {
                e.preventDefault();
                courseTabs.switchTab($(this));
                courseTabs.changeHash();
            });

            var hash = window.location.hash;
            if (typeof hash !== 'undefined' && hash !== '') {
                hash = hash.replace('#tab-', '#');
                var currentTab = $('a[href*="' + hash + '"]');
                if (currentTab.length) {
                    currentTab.click();
                } else {
                    this.activeTab();
                }
            } else {
                this.activeTab();
            }
        },

        activeTab: function() {
            let activeTab = courseTabs.tabs.find('.active');
            if (activeTab.length) {
                activeTab.find('.course-tab').click();
            } else {
                this.tabs.children().first().find('.course-tab').click();
            }
        },

        switchTab: function(element) {
            this.hash = element.attr('href');
            element.parent().addClass('active').siblings().removeClass('active');
            $(this.hash).siblings().hide();
            $(this.hash).fadeIn(200);
        },

        changeHash: function() {
            if (this.hash !== '') {
                window.location.hash = this.hash.replace('#', '#tab-');
                this.hash = '';
            }
        }
    };

    var Blocks = function($scope) {
        $scope.find('.pb-block').each(function() {
            Talemy_Block($(this));
        });
    }

    var CourseSearch = function($scope) {
        $scope.find('select').selectric();
    }

    var EventsCountdown = function($scope) {
       var $element = $scope.find('.events-countdown-timer'),
           date = new Date($element.data('date') * 1000);

        new Timer($element, date);
    }

    var CustomSlider = function($scope) {
        var $container = $scope.find('.swiper');
        if ($container.length === 0) {
            return;
        }

        var settings = $container.data('settings');
        var swiper = new Swiper($container[0], settings);

        var prevButton = $scope.find('.prev-slide');
        var nextButton = $scope.find('.next-slide');

        prevButton.on('click', function() {
            swiper.slidePrev();
        });

        nextButton.on('click', function() {
            swiper.slideNext();
        });
    }

    var Slider = function($scope) {
        var $container = $scope.find('.swiper');
        if ($container.length === 0) {
            return;
        }
        var settings = $container.data('settings');
        new Swiper($container[0], settings);
    };

    var Timer = function($element, endTime) {
        var timeInterval,
            $elements = {
                $daysSpan: $element.find('.events-countdown-days'),
                $hoursSpan: $element.find('.events-countdown-hours'),
                $minutesSpan: $element.find('.events-countdown-minutes'),
                $secondsSpan: $element.find('.events-countdown-seconds')
            };

        var updateTimer = function() {
            var timeRemaining = Timer.getTimeRemaining(endTime);

            $.each(timeRemaining.parts, function(timePart) {
                var $element = $elements['$' + timePart + 'Span'],
                    partValue = this.toString();

                if (1 === partValue.length) {
                    partValue = 0 + partValue;
                }

                if ($element.length) {
                    $element.text(partValue);
                }
            });

            if (timeRemaining.total <= 0) {
                clearInterval(timeInterval);
            }
        };

        var init = function() {
            updateTimer();
            timeInterval = setInterval(updateTimer, 1000);
        };

        init();
    };

    Timer.getTimeRemaining = function(endTime) {
        var timeRemaining = endTime - new Date(),
            seconds = Math.floor((timeRemaining / 1000) % 60),
            minutes = Math.floor((timeRemaining / 1000 / 60) % 60),
            hours = Math.floor((timeRemaining / (1000 * 60 * 60)) % 24),
            days = Math.floor(timeRemaining / (1000 * 60 * 60 * 24));

        if (days < 0 || hours < 0 || minutes < 0) {
            seconds = minutes = hours = days = 0;
        }

        return {
            total: timeRemaining,
            parts: {
                days: days,
                hours: hours,
                minutes: minutes,
                seconds: seconds
            }
        };
    };

    function navButtons() {
        if (matchMaxWidth(768)) {
            var accountBtn = $('.header-wrapper .account-dropdown');

            if (accountBtn.length) {
                $('.navbar-wrapper .nav-btns').prepend(accountBtn.parent());
            }
        } else {
            var accountBtn = $('.navbar-wrapper .account-dropdown');

            if (accountBtn.length) {
                $('.header-wrapper .nav-btns').append(accountBtn.parent());
            }
        }
    }

    /**
     * Elementor elements
     */
    $window.on('elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction('frontend/element_ready/talemy-course-categories.default', Slider);
        elementorFrontend.hooks.addAction('frontend/element_ready/talemy-course-search.default', CourseSearch);
        elementorFrontend.hooks.addAction('frontend/element_ready/talemy-block-courses.default', Blocks);
        elementorFrontend.hooks.addAction('frontend/element_ready/talemy-block-groups.default', Blocks);
        elementorFrontend.hooks.addAction('frontend/element_ready/talemy-block-posts.default', Blocks);
        elementorFrontend.hooks.addAction('frontend/element_ready/talemy-events-countdown.default', EventsCountdown);
        elementorFrontend.hooks.addAction('frontend/element_ready/talemy-events-slider.default', CustomSlider);
        elementorFrontend.hooks.addAction('frontend/element_ready/talemy-info-boxes.default', CustomSlider);
    });

    $(document).ready(function() {
        wpadminbar.init();
        navigation.init();
        $('.navbar').stickyNavbar();
        layouts.init();
        stickySidebar();
        commonFeatures();
        courseTabs.init();
        stickyFooter();
        courseSidebar();
    });

    $window.on("resize orientationchange", $.debounce(200, function() {
        wpadminbar.init();
        popoverPosition();
        moveCourseSidebar();
        layouts.init();
        stickyFooter();
        navButtons();
        courseSidebar();
    }));

    return self;

})(jQuery);
