<?php
/**
 * Share buttons
 *
 * This template can be overridden by copying it to yourtheme/spirit/post-shrae-buttons.php.
 *
 * @package    Spirit Framework/Templates
 * @version    1.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$show_share    = apply_filters( 'sf_show_social_share', true );
$share_buttons = apply_filters( 'sf_share_buttons', ['facebook', 'twitter', 'pinterest'] );

if ( ! $show_share || empty( $share_buttons ) ) {
	return;
}

$share_networks      = sf_get_share_networks();
$social_icon_classes = sf_get_social_icon_classes();
$social_icon_names   = sf_get_social_icon_names();
$social_icon_colors  = sf_get_social_icon_colors();
$social_urls         = [
	'facebook'  => 'https://www.facebook.com/sharer/sharer.php?u={url}',
	'twitter'   => 'https://twitter.com/share?url={url}&text={text}&via={via}',
	'pinterest' => 'http://pinterest.com/pin/create/button/?url={url}&media={img}&description={text}',
	'linkedin'  => 'https://www.linkedin.com/shareArticle?url={url}&title={text}',
	'reddit'    => 'https://reddit.com/submit?url={url}&title={text}',
	'vk'        => 'http://vk.com/share.php?url={url}&title={text}',
	'telegram'  => 'https://t.me/share/url?url={url}&text={text}',
	'viber'     => 'viber://forward?text={url}',
	'whatsapp'  => 'whatsapp://send?text={url}',
	'email'     => 'mailto:?subject={text}&body={url}',
];
$has_text = [ 'facebook', 'twitter', 'pinterest' ];
$texts    = [
	'facebook'  => __( 'Share', 'spirit' ),
	'twitter'   => __( 'Tweet', 'spirit' ),
	'pinterest' => __( 'Pin it', 'spirit' ),
];
$image       = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'large' );
$post_image  = ! $image ? '' : $image[0];
$post_url    = rawurlencode( get_the_permalink() );
$post_title  = rawurlencode( get_the_title() );
$twitter_via = get_theme_mod( 'social_twitter_at', get_bloginfo( 'name' ) );
?>
<div class="post-share">
	<div class="social-list" data-color="official">
	<?php
	foreach ( $share_buttons as $item ):
		$icon_class = isset( $social_icon_classes[$item] ) ? $social_icon_classes[$item] : '';
		$icon_name  = isset( $social_icon_names[$item] ) ? $social_icon_names[$item] : '';
		$icon_color = isset( $social_icon_colors[$item] ) ? $social_icon_colors[$item] : '';
		$title      = sprintf( esc_html__( 'Share on %s', 'spirit' ), $icon_name );
		$social_url = isset( $social_urls[$item] ) ? $social_urls[$item] : '';
		$url        = str_replace(
			[
				'{url}',
				'{text}',
				'{img}',
				'{via}',
			],
			[
				$post_url,
				$post_title,
				$post_image,
				$twitter_via
			],
			$social_url
		);
		?>
		<a href="<?php echo esc_url( $url ); ?>" class="<?php echo esc_attr( $icon_class ); ?>" title="<?php echo esc_attr( $title ); ?>" aria-label="<?php echo esc_attr( $title ); ?>" rel="noopener noreferrer nofollow" style="--official-color:<?php echo esc_attr( $icon_color ); ?>">
			<span class="social-icon"><?php sf_social_svg_icon( $item ); ?></span>
			<?php if ( in_array( $item, $has_text ) ) : ?>
				<span class="social-label"><?php echo esc_html( $texts[ $item ] ); ?></span>
			<?php endif; ?>
		</a>
	<?php endforeach; ?>
	</div>
</div>