<?php
/**
 * New account email
 *
 * This template can be overridden by copying it to yourtheme/spirit/emails/plain/new-account.php.
 *
 * @package 	Spirit Framework/Templates/Emails/Plain
 * @version     1.0.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! empty( $email_content ) ) {

	echo esc_html( wp_strip_all_tags( wptexturize( $email_content ) ) );

} else {

	echo "= " . $email_heading . " =\n\n";

	echo sprintf( __( 'Thanks for creating an account on %s.', 'spirit' ), $blogname ) . "\n\n";
	
	echo sprintf( __( 'Username: %s', 'spirit' ), $user_login ) . "\n\n";
	
	if ( $password_generated ) {
		echo sprintf( __( 'Password: %s', 'spirit' ), $user_pass ) . "\n\n";
	} else {
		echo __( 'Password: [Password entered at registration]', 'spirit' ) . "\n\n";
	}
	
	echo sprintf( __( 'Login URL: %s', 'spirit' ), $login_url ) . "\n\n";
	
	echo "\n=====================================================================\n\n";
	
	echo apply_filters( 'sf_email_footer_text', SF()->get_setting( 'email_footer_text' ) );
}


