<?php
/**
 * New account email
 *
 * This template can be overridden by copying it to yourtheme/spirit/emails/new-account.php.
 *
 * @package 	Spirit Framework/Templates/Emails
 * @version     1.0.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

?>

<?php do_action( 'sf_email_header', $email_heading, $email ); ?>

	<?php if ( ! empty( $email_content ) ) : ?>

		<?php echo wp_kses_post( wpautop( wptexturize( $email_content ) ) ); ?>

	<?php else : ?>

		<p><?php printf( __( 'Thanks for creating an account on %s.', 'spirit' ), esc_html( $blogname ) ); ?></p>

		<p><?php printf( __( 'Username: %s', 'spirit' ), '<strong>' . esc_html( $user_login ) . '</strong>' ); ?></p>

		<?php if ( $password_generated ) : ?>

			<p><?php printf( __( 'Password: %s', 'spirit' ), '<strong>' . esc_html( $user_pass ) . '</strong>' ); ?></p>

		<?php else: ?>

			<p><?php _e( 'Password: [Password entered at registration]', 'spirit' ); ?></p>

		<?php endif; ?>

		<p><?php printf( __( 'Login URL: %s', 'spirit' ), make_clickable( esc_url( $login_url ) ) ); ?></p>

	<?php endif; ?>

<?php do_action( 'sf_email_footer', $email );
