<?php
/**
 * Login Box
 *
 * This template can be overridden by copying it to yourtheme/spirit/account/login-box.php.
 *
 * @package Spirit_Framework/Templates
 * @version 1.1.8
 * 
 */

defined( 'ABSPATH' ) || exit; // Exit if accessed directly.

$args = [
	'minimum_password_strength' => $minimum_password_strength,
	'login_redirect_url' => $login_redirect_url,
	'registration_redirect_url' => $registration_redirect_url
];

do_action( 'sf_login_box_before' ); ?>
<div class="sf-login-wrapper">
<?php if ( ! is_user_logged_in() ): ?>
	<div class="sf-login-tabs">
		<a href="#login" class="sf-login-tab"><?php esc_html_e( 'Log In', 'spirit' ); ?></a>
		<a href="#register" class="sf-register-tab"><?php esc_html_e( 'Register', 'spirit' ); ?></a>
		<a href="#lostpassword" class="sf-lost-tab"><?php esc_html_e( 'Reset your possword', 'spirit' ); ?></a>
	</div>
	<div class="sf-login-forms">
		<?php sf_get_template( 'account/form-login.php', $args ); ?>
		<?php sf_get_template( 'account/form-register.php', $args ); ?>
		<?php sf_get_template( 'account/form-lost-password.php', $args ); ?>
		<div class="sf-social-login"><?php sf_get_template( 'account/social-login.php' ); ?></div>
	</div>
<?php else: ?>
<?php $user = wp_get_current_user(); ?>
	<div class="sf-user-details">
		<figure class="sf-user-avatar"><?php echo get_avatar( $user->ID, 80 ); ?></figure>
		<h2 class="sf-user-name"><?php echo $user->first_name; ?></h2>
		<?php do_action( 'sf_logged_in_content' ); ?>
		<a href="<?php echo wp_logout_url( home_url() ); ?>" class="btn btn-secondary btn-block"><?php esc_html_e( 'Logout', 'spirit' ); ?></a>
	</div>
<?php endif; ?>
</div>
<?php do_action( 'sf_login_box_after' ); ?>