<?php
/**
 * Reset Password Form
 *
 * This template can be overridden by copying it to yourtheme/spirit/account/form-reset-password.php.
 *
 * @package Spirit_Framework/Templates
 * @version 1.1.8
 * 
 */

defined( 'ABSPATH' ) || exit; // Exit if accessed directly.

$form_message = ! empty( $form_message ) ? $form_message : '';

?>
<form method="post" action="<?php echo esc_url( sf_get_reset_password_link() ); ?>" class="sf-reset-password-form" data-min-pass-strength="<?php echo esc_attr( apply_filters( 'sf_minimum_password_strength', $minimum_password_strength ) ); ?>">

	<?php do_action( 'sf_reset_password_form_start' ); ?>

	<div class="sf-form-message"><?php echo $form_message; ?></div>
	<div class="sf-form-row">
		<div class="sf-form-control-wrap">
			<?php sf_form_icon( 'password' ); ?>
			<input type="password" name="sf-password" class="sf-password validate" placeholder="<?php esc_html_e( 'New Password', 'spirit' ); ?>" data-pw="<?php echo esc_attr( wp_generate_password( 16 ) ); ?>" autocomplete="off" aria-describedby="sf-pw-strength-meter">
			<button type="button" class="sf-hide-pw hide-if-no-js" aria-label="<?php esc_html_e( 'Show password', 'spirit' ); ?>" tabindex="-1">
				<?php sf_form_icon( 'show_password', [
						'data-show' => sf_get_form_icon_class( 'show_password' ),
						'data-hide' => sf_get_form_icon_class( 'hide_password' )
					], 'span' ); ?>	
			</button>
		</div>
		<?php if ( SF()->get_setting( 'password_strength_meter' ) ) : ?>
			<div class="sf-pw-strength-meter" class="hide-if-no-js" aria-live="polite"></div>
			<div class="sf-pw-weak">
				<label for="sf-pw-weak" class="checkbox">
					<input type="checkbox" name="sf-pw-weak" id="sf-pw-weak" class="sf-pw-weak-checkbox" />
					<span><?php esc_html_e( 'Confirm use of weak password', 'spirit' ); ?></span>
				</label>
			</div>
		<?php endif; ?>
	</div>

	<?php do_action( 'sf_reset_password_form' ); ?>

	<input type="hidden" name="rp_key" value="<?php echo esc_attr( $rp_key ); ?>" />
	<button type="submit" class="btn btn-primary btn-lg btn-block"><?php esc_html_e( 'Reset Password', 'spirit' ); ?></button>

	<?php do_action( 'sf_reset_password_form_end' ); ?>

</form>