<?php
/**
 * Register Form
 *
 * This template can be overridden by copying it to yourtheme/spirit/account/form-register.php.
 *
 * @package Spirit_Framework/Templates
 * @version 1.1.8
 * 
 */

defined( 'ABSPATH' ) || exit; // Exit if accessed directly.

?>
<form method="post" action="<?php echo wp_registration_url(); ?>" class="sf-register-form" data-min-pass-strength="<?php echo esc_attr( apply_filters( 'sf_minimum_password_strength', $minimum_password_strength ) ); ?>">

	<div class="sf-form-message"></div>
	
	<?php do_action( 'sf_register_form_start' ); ?>
	
	<?php if ( SF()->get_setting( 'new_account_first_last_name' ) ) : ?>
		
		<div class="sf-form-row sf-row-cols-2">
			<div class="sf-col">
				<?php sf_form_icon( 'first_name' ); ?>
				<input type="text" name="sf-firstname" class="sf-firstname validate" placeholder="<?php esc_html_e( 'First name', 'spirit' ); ?>" aria-label="<?php esc_html_e( 'First name', 'spirit' ); ?>">
			</div>
			<div class="sf-col">
				<?php sf_form_icon( 'last_name' ); ?>
				<input type="text" name="sf-lastname" class="sf-lastname validate" placeholder="<?php esc_html_e( 'Last name', 'spirit' ); ?>" aria-label="<?php esc_html_e( 'Last name', 'spirit' ); ?>">
			</div>
		</div>
		
	<?php endif; ?>
	
	<?php if ( ! SF()->get_setting( 'new_account_generate_username' ) ) : ?>

		<div class="sf-form-row">
			<?php sf_form_icon( 'username' ); ?>
			<input type="text" name="sf-username" class="sf-username validate" placeholder="<?php esc_html_e( 'Username', 'spirit' ); ?>" aria-label="<?php esc_html_e( 'Username', 'spirit' ); ?>">
		</div>
	
	<?php endif; ?>

	<div class="sf-form-row">
		<?php sf_form_icon( 'email' ); ?>
		<input type="text" name="sf-email" class="sf-email validate" placeholder="<?php esc_html_e( 'Email', 'spirit' ); ?>" aria-label="<?php esc_html_e( 'Email', 'spirit' ); ?>">
	</div>

	<?php if ( ! SF()->get_setting( 'new_account_generate_password' ) ) : ?>
	
		<div class="sf-form-row">
			<div class="sf-form-control-wrap sf-form-control-pass">
				<?php sf_form_icon( 'password' ); ?>
				<input type="password" name="sf-password" class="sf-password validate" placeholder="<?php esc_html_e( 'Password', 'spirit' ); ?>" autocomplete="off" aria-describedby="sf-pw-strength-meter">
				<button type="button" class="sf-hide-pw hide-if-no-js" aria-label="<?php esc_html_e( 'Show password', 'spirit' ); ?>" tabindex="-1" >
					<?php sf_form_icon( 'show_password', [
							'data-show' => sf_get_form_icon_class( 'show_password' ),
							'data-hide' => sf_get_form_icon_class( 'hide_password' )
						], 'span' ); ?>
				</button>
			</div>
			<?php if ( SF()->get_setting( 'password_strength_meter' ) ) : ?>
				<div class="sf-pw-strength-meter empty" class="hide-if-no-js" aria-live="polite"></div>
			<?php endif; ?>
		</div>
		<div class="sf-form-row">
			<div class="sf-form-control-wrap sf-form-control-pass2">
				<?php sf_form_icon( 'password' ); ?>
				<input type="password" name="sf-password2" class="sf-password validate" placeholder="<?php esc_html_e( 'Confirm Password', 'spirit' ); ?>" autocomplete="off" aria-describedby="sf-pw-strength-meter">
				<button type="button" class="sf-hide-pw hide-if-no-js" aria-label="<?php esc_html_e( 'Show password', 'spirit' ); ?>" tabindex="-1">
					<?php sf_form_icon( 'show_password', [
							'data-show' => sf_get_form_icon_class( 'show_password' ),
							'data-hide' => sf_get_form_icon_class( 'hide_password' )
						], 'span' ); ?>
				</button>
			</div>
			<?php if ( SF()->get_setting( 'password_strength_meter' ) ) : ?>
				<div class="sf-pw-weak">
					<label for="sf-pw-weak" class="checkbox">
						<input type="checkbox" name="sf-pw-weak" id="sf-pw-weak" class="sf-pw-weak-checkbox" />
						<span><?php esc_html_e( 'Confirm use of weak password', 'spirit' ); ?></span>
					</label>
				</div>
			<?php endif; ?>
		</div>

	<?php endif; ?>

	<?php do_action( 'sf_register_form' ); ?>
	
	<?php if ( ! empty( SF()->get_setting( 'new_account_agreement_text' ) ) ) : ?>
		
		<div class="sf-form-row">
			<label class="checkbox">
				<input type="checkbox" name="sf-account-agreement" checked required />
				<span><?php echo sf_get_new_account_agreement_text(); ?></span>
			</label>
		</div>

	<?php endif; ?>
	
	<button type="submit" class="btn btn-primary btn-lg btn-block"><?php esc_html_e( 'Register', 'spirit' ); ?></button>
	<input type="hidden" class="sf-register-nonce" name="sf-register-nonce" value="<?php echo wp_create_nonce( 'sf_register_nonce' ); ?>">

	<?php do_action( 'sf_register_form_end' ); ?>

</form>