<?php
/**
 * Login Form
 *
 * This template can be overridden by copying it to yourtheme/spirit/account/form-login.php.
 *
 * @package Spirit_Framework/Templates
 * @version 1.1.8
 * 
 */

defined( 'ABSPATH' ) || exit; // Exit if accessed directly.

if ( ! is_user_logged_in() ) :

	$form_message = ! empty( $form_message ) ? $form_message : ''; ?>

	<form method="post" action="<?php echo wp_login_url(); ?>" class="sf-login-form" data-redirect="<?php echo esc_url( $login_redirect_url ); ?>">
		
		<?php do_action( 'sf_login_form_start' ); ?>
		
		<div class="sf-form-message"><?php echo $form_message; ?></div>
		<div class="sf-form-row">
			<?php sf_form_icon( 'username' ); ?>
			<input type="text" name="sf-username" class="sf-username validate" placeholder="<?php esc_html_e( 'Username or Email', 'spirit' ); ?>">
		</div>
		<div class="sf-form-row">
			<div class="sf-form-control-wrap">
				<?php sf_form_icon( 'password' ); ?>	
				<input type="password" name="sf-userpass" class="sf-userpass validate" placeholder="<?php esc_html_e( 'Password', 'spirit' ); ?>">
				<button type="button" class="sf-hide-pw hide-if-no-js" aria-label="<?php esc_html_e( 'Show password', 'spirit' ); ?>" tabindex="-1">
					<?php sf_form_icon( 'show_password', [
							'data-show' => sf_get_form_icon_class( 'show_password' ),
							'data-hide' => sf_get_form_icon_class( 'hide_password' )
						], 'span' ); ?>
				</button>
			</div>
		</div>

		<?php do_action( 'sf_login_form' ); ?>
		
		<?php if ( SF()->get_setting( 'login_remember_me' ) ) : ?>
			
			<div class="sf-form-row">
				<?php $id_suffix = uniqid(); ?>
				<label for="sf-remember-<?php echo esc_attr( $id_suffix ); ?>" class="checkbox">
					<input type="checkbox" id="sf-remember-<?php echo esc_attr( $id_suffix ); ?>" name="sf-rememberme" class="sf-rememberme">
					<span><?php esc_html_e( 'Remember Me', 'spirit' ); ?></span>
				</label>
			</div>
		
		<?php endif; ?>
		
		<button type="submit" class="btn btn-primary btn-lg btn-block"><?php esc_html_e( 'Log In', 'spirit' ); ?></button>
		<input type="hidden" class="sf-login-nonce" name="sf-login-nonce" value="<?php echo wp_create_nonce( 'sf_login_nonce' ); ?>">
		
		<?php do_action( 'sf_login_form_end' ); ?>

	</form>

<?php endif; ?>
