<?php

add_action( 'sf_post_share_buttons', 'sf_post_share_buttons' );

if ( ! function_exists( 'sf_post_share_buttons' ) ) {
	/**
	 * Display share buttons on single post
	 */
    function sf_post_share_buttons() {
		wp_enqueue_script( 'sf-share' );
        sf_get_template( 'post-share-buttons.php' );
    }
}

add_action( 'sf_author_social_links', 'sf_author_social_links', 10, 1 );

if ( ! function_exists( 'sf_author_social_links' ) ) {
	/**
	 * Display site social links
	 * 
	 * @param integer $author_id author ID
	 */
    function sf_author_social_links( $author_id = null ) {
    	$social_links = get_the_author_meta( 'sf_social_links', $author_id );
   		$social_links_data = sf_get_social_icons_data( $social_links );
    	sf_social_icons( $social_links_data, 'author-social' );
    }
}

add_action( 'sf_site_social_links', 'sf_site_social_links', 10, 1 );

if ( ! function_exists( 'sf_site_social_links' ) ) {
	/**
	 * Display site social links
	 * 
	 * @param string $class wrapper class
	 */
    function sf_site_social_links( $class = '' ) {
    	$mods = get_theme_mods();
    	$social_links = array();
    	foreach( sf_get_social_icon_names() as $key => $label ) {
    		if ( !empty( $mods[ "social_{$key}" ] ) ) {
    			$social_links[ $key ] = $mods[ "social_{$key}" ];
    		}
    	}
       	$social_links_data = sf_get_social_icons_data( $social_links );
        sf_social_icons( $social_links_data, $class );
    }
}

add_filter( 'pre_get_avatar_data', 'sf_custom_avatar', 10, 2 );

if ( ! function_exists( 'sf_custom_avatar' ) ) {
	/**
	 * Custom avatar
	 *
	 * @param array $args
	 * @param int|string $id_or_email
	 * @return array
	 */
	function sf_custom_avatar( $args, $id_or_email ) {
		if ( is_numeric( $id_or_email ) ) {
			$user = get_user_by( 'id', absint( $id_or_email ) );
		} elseif ( is_string( $id_or_email ) ) {
			$user = get_user_by( 'email', $id_or_email );
		} elseif ( $id_or_email instanceof WP_User ) {
			$user = $id_or_email;
		}
		if ( ! empty( $user ) ) {
			$image_id = get_user_meta( $user->ID, 'sf_user_avatar', true );
			if ( ! empty( $image_id ) ) {
				$url = wp_get_attachment_image_url( $image_id, [ $args['width'], $args['height'] ] );
				if ( false === $url ) {
					$url = $image_id;
				}
				$args['url'] = $url;
			}
		}
		return $args;	
	}
}