<?php

if ( ! defined( 'BSF_CUSTOM_FONTS_VER' ) ) {
	return;
}

/**
 * Custom fonts optroup.
 *
 * @param array $custom_choice The custom choice.
 *
 * @return array The updated custom choice.
 */
add_filter( 'sf_kirki_font_choices', function( $custom_choice ) {
	$args                 = array(
		'post_type'      => BSF_CUSTOM_FONTS_POST_TYPE,
		'post_status'    => 'publish',
		'fields'         => 'ids',
		'no_found_rows'  => true,
		'posts_per_page' => '-1',
	);
	$query                = new WP_Query( $args );
	$all_fonts = $query->posts;

	if ( ! empty( $all_fonts ) ) {
		$custom_fonts = [];
		$font_variants = [];

		foreach ( $all_fonts as $key => $post_id ) {
			$font_data = get_post_meta( $post_id, 'fonts-data', true );
			$font_type = get_post_meta( $post_id, 'font-type', true );

			if ( 'google' !== $font_type ) {
				$variants = ['regular'];
				$font_name = $font_data['font_name'];
				if ( ! empty( $font_data['variations'] ) ) {
					foreach ( $font_data['variations'] as $var_key => $var_data ) {
						$variants[] = $var_data['font_weight'];
					}
				}
				$custom_fonts[] = [
					'id' => $font_name,
					'text' => $font_name,
				]; 
				$font_variants[ $font_name ] = $variants;
			}
		}

		$custom_choice['families']['bsf_custom_fonts'] = [
			'text'     => esc_attr__( 'Custom Fonts', 'spirit' ),
			'children' => $custom_fonts,
			'variants' => $font_variants,
		];
	}
	return $custom_choice;

}, 10 );