<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class SF_Testimonials extends SF_Slider_Base {

	public function get_name() {
		return 'sf-testimonials';
	}

	public function get_title() {
		return __( 'Testimonials', 'spirit' );
	}

	public function get_icon() {
		return 'eicon-testimonial-carousel sf-addons-label';
	}
	
	protected function register_controls() {

        $this->start_controls_section(
            'section_items',
            [
                'label' => esc_attr__( 'Items', 'spirit' ),
            ]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'content',
			[
				'label' => __( 'Content', 'spirit' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => '',
				'label_block' => true
			]
		);

		$repeater->add_control(
			'image',
			[
				'label' => __( 'Image', 'spirit' ),
				'type' => Controls_Manager::MEDIA
			]
		);

		$repeater->add_control(
			'name',
			[
				'label' => __( 'Name', 'spirit' ),
				'type' => Controls_Manager::TEXT,
				'default' => 'John Doe',
				'label_block' => true
			]
		);

		$repeater->add_control(
			'title',
			[
				'label' => __( 'Title', 'spirit' ),
				'type' => Controls_Manager::TEXT,
				'default' => 'CEO',
				'label_block' => true
			]
		);

		$this->add_control(
			'items',
			[
				'label' => __( 'Testimonials', 'spirit' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'name' => 'John Doe',
						'title' => 'Developer',
						'content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.'
					],
					[
						'name' => 'Jane Roe',
						'title' => 'Author',
						'content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.'
					],
					[
						'name' => 'Joe Harris',
						'title' => 'Entreprenuer',
						'content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.'
					]
				],
				'title_field' => '{{{ name }}}'
			]
		);

        $this->end_controls_section();

		$this->register_slider_controls_section();

		$this->start_controls_section(
			'section_items_style',
			[
				'label' => __( 'General', 'spirit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'skin',
			[
				'label' => __( 'Skin', 'spirit' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default' => __( 'Default', 'spirit' ),
					'card' => __( 'Card', 'spirit' ),
				],
				'prefix_class' => 'sf-testimonial--skin-',
			]
		);

		$this->add_control(
			'layout',
			[
				'label' => __( 'Layout', 'spirit' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'image_above',
				'options' => [
					'image_inline' => __( 'Image Inline', 'spirit' ),
					'image_above' => __( 'Image Above', 'spirit' ),
					'image_top' => __( 'Image Top', 'spirit' ),
					'image_left' => __( 'Image Left', 'spirit' ),
					'image_right' => __( 'Image Right', 'spirit' ),
				],
				'prefix_class' => 'sf-testimonial--layout-',
				'render_type' => 'template',
			]
		);

		$this->add_control(
			'alignment',
			[
				'label' => __( 'Alignment', 'spirit' ),
				'type' => Controls_Manager::CHOOSE,
				'label_block' => false,
				'default' => 'center',
				'options' => [
					'left' => [
						'title' => __( 'Left', 'spirit' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'spirit' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'spirit' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'prefix_class' => 'sf-testimonial--align-',
			]
		);

        $this->add_responsive_control(
            'spacing',
            [
                'label' => __( 'Space Between', 'spirit' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                	'size' => 30,
                	'unit' => 'px',
                ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'render_type' => 'template'
            ]
		);
		
		$this->add_responsive_control(
			'padding',
			[
				'label' => __( 'Padding', 'spirit' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .sf-testimonial' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'border',
				'label' => esc_html__( 'Border', 'spirit' ),
				'selector' => '{{WRAPPER}} .sf-testimonial',
				'separator' => 'before'
			]
		);

		$this->add_responsive_control(
			'border_radius',
			[
				'label' => __( 'Border Radius', 'spirit' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .sf-testimonial' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .sf-swiper-container-bg' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
		
		$this->add_control(
			'show_shadow_bg',
			[
				'label' => __( 'Show Shadow Background', 'spirit' ),
				'type'  => Controls_Manager::SWITCHER,
				'default' => 'no',
				'separator' => 'before'
			]	
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_style',
			[
				'label' => __( 'Content', 'spirit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'content_bg_color',
			[
				'label' => __( 'Background Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-testimonial' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'content_color',
			[
				'label' => __( 'Text Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-testimonial__text' => 'color: {{VALUE}}',
				],
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'selector' => '{{WRAPPER}} .sf-testimonial__text',
			]
		);

		$this->add_control(
			'name_style',
			[
				'label' => __( 'Name', 'spirit' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'name_color',
			[
				'label' => __( 'Text Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-testimonial__name' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'name_typography',
				'selector' => '{{WRAPPER}} .sf-testimonial__name',
			]
		);

        $this->add_responsive_control(
            'name_spacing',
            [
                'label' => __( 'Spacing', 'spirit' ),
                'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100
					]
				],
				'selectors' => [
					'{{WRAPPER}} .sf-testimonial__cite' => 'margin-top: {{SIZE}}{{UNIT}};'
				]
            ]
        );

		$this->add_control(
			'title_style',
			[
				'label' => __( 'Title', 'spirit' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => __( 'Text Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-testimonial__title' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
            'title_spacing',
            [
                'label' => __( 'Spacing', 'spirit' ),
                'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100
					]
				],
				'selectors' => [
					'{{WRAPPER}} .sf-testimonial__title' => 'margin-top: {{SIZE}}{{UNIT}};'
				]
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'section_image_style',
			[
				'label' => __( 'Image', 'spirit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'image_size',
			[
				'label' => __( 'Image Size', 'spirit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 20,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .sf-testimonial__image img' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} .sf-testimonial__image img' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}}.sf-testimonial--layout-image_above .sf-testimonial__image' => 'top: calc({{SIZE}}{{UNIT}} * 0.5 * -1);',
					'{{WRAPPER}}.sf-testimonial--layout-image_above .sf-testimonial.has-image' => 'margin-top: calc({{SIZE}}{{UNIT}} *0.5);',
					'{{WRAPPER}}.sf-testimonial--layout-image_above .sf-swiper-container-bg' => 'top: calc({{SIZE}}{{UNIT}} *0.5);',
				]
			]
		);

		$this->add_control(
			'image_gap',
			[
				'label' => __( 'Image Gap', 'spirit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}}.sf-testimonial--layout-image_left .sf-testimonial__content' => 'padding-left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}}.sf-testimonial--layout-image_right .sf-testimonial__content' => 'padding-right: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}}.sf-testimonial--layout-image_top .sf-testimonial__image' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}}.sf-testimonial--layout-image_above.sf-testimonial--skin-card .has-image .sf-testimonial__content' => 'padding-top:{{SIZE}}{{UNIT}}!important;',
				],
			]
		);

		$this->end_controls_section();

        $this->register_navigation_style_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		if ( empty( $settings['items'] ) ) {
			return;
		}

		$image_top = false;
		if ( 'image_above' == $settings['layout'] || 'image_top' == $settings['layout'] ) {
			$image_top = true;
		}
		
		// use unique id selector
        $prev_btn_id = uniqid();
        $next_btn_id = uniqid();
        $pagination_id = uniqid();
        $settings['prev_btn_selector'] = '#sf-swiper-btn-'. $prev_btn_id;
        $settings['next_btn_selector'] = '#sf-swiper-btn-'. $next_btn_id;
        $settings['pagination_selector'] = '#sf-swiper-pagination-'. $pagination_id;
		?>
		<div class="sf-testimonials clearfix">
			<div class="sf-swiper-container">
				<div class="swiper" data-settings='<?php echo wp_json_encode( $this->get_slider_settings( $settings ) ); ?>'>
					<div class="swiper-wrapper">
						<?php foreach ( $settings['items'] as $item ) : ?>
							<div class="swiper-slide">
								<div class="sf-testimonial<?php if ( $item['image']['url'] ) { echo ' has-image'; } ?>">
									<div class="sf-testimonial__content">
										<?php if ( $item['image']['url'] && $image_top ) : ?>
										<div class="sf-testimonial__image">
											<img src="<?php echo esc_url( $item['image']['url'] ); ?>" alt="<?php echo esc_html( $item['title'] ); ?>">
										</div>
										<?php endif; ?>
										<div class="sf-testimonial__text">
											<?php echo esc_html( $item['content'] ); ?>
										</div>
										<?php if ( 'image_inline' != $settings['layout'] ) : ?>
											<cite class="sf-testimonial__cite">
											<?php if ( ! empty( $item['name'] ) ) : ?>
												<h4 class="sf-testimonial__name"><?php echo esc_html( $item['name'] ); ?></h4>
											<?php endif; ?>
											<?php if ( ! empty( $item['title'] ) ) : ?>
												<span class="sf-testimonial__title"><?php echo esc_html( $item['title'] ); ?></span>
											<?php endif; ?>
											</cite>
										<?php endif; ?>
									</div>
									<div class="sf-testimonial__footer">
										<?php if ( $item['image']['url'] && !$image_top ) : ?>
										<div class="sf-testimonial__image">
											<img src="<?php echo esc_url( $item['image']['url'] ); ?>" alt="<?php echo esc_html( $item['title'] ); ?>">
										</div>
										<?php endif; ?>
										<?php if ( 'image_inline' == $settings['layout'] ) : ?>
											<cite class="sf-testimonial__cite">
											<?php if ( ! empty( $item['name'] ) ) : ?>
												<h4 class="sf-testimonial__name"><?php echo esc_html( $item['name'] ); ?></h4>
											<?php endif; ?>
											<?php if ( ! empty( $item['title'] ) ) : ?>
												<span class="sf-testimonial__title"><?php echo esc_html( $item['title'] ); ?></span>
											<?php endif; ?>
											</cite>
										<?php endif; ?>
									</div>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
               <?php $this->slider_navigation( $settings ); ?>
				<?php if ( isset( $settings['show_shadow_bg'] ) && 'yes' === $settings['show_shadow_bg'] ) : ?>
					<div class="sf-swiper-container-bg"></div>
				<?php endif; ?>
			</div>
		</div>
		<?php
	}
}

Plugin::instance()->widgets_manager->register( new SF_Testimonials() );