<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class SF_Testimonials_Carousel extends SF_Slider_Base {

	public function get_name() {
		return 'sf-testimonials-carousel';
	}

	public function get_title() {
		return __( 'Testimonials Carousel', 'spirit' );
	}

	public function get_icon() {
		return 'eicon-testimonial-carousel sf-addons-label';
	}
	
	protected function register_controls() {

        $this->start_controls_section(
            'section_items',
            [
                'label' => esc_attr__( 'Items', 'spirit' ),
            ]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'content',
			[
				'label' => __( 'Content', 'spirit' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => '',
				'label_block' => true
			]
		);

		$repeater->add_control(
			'image',
			[
				'label' => __( 'Image', 'spirit' ),
				'type' => Controls_Manager::MEDIA
			]
		);

		$repeater->add_control(
			'name',
			[
				'label' => __( 'Name', 'spirit' ),
				'type' => Controls_Manager::TEXT,
				'default' => 'John Doe',
				'label_block' => true
			]
        );

		$repeater->add_control(
			'title',
			[
				'label' => __( 'Title', 'spirit' ),
				'type' => Controls_Manager::TEXT,
				'default' => 'CEO',
				'label_block' => true
			]
		);

		$this->add_control(
			'items',
			[
				'label' => __( 'Testimonials', 'spirit' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'name' => 'John Doe',
						'title' => 'CEO',
						'content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.'
					],
					[
						'name' => 'John Doe',
						'title' => 'CEO',
						'content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.'
					],
					[
						'name' => 'John Doe',
						'title' => 'CEO',
						'content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.'
					]
				],
				'title_field' => '{{{ name }}}'
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'section_slider',
			[
				'label' => __( 'Slider', 'spirit' ),
				'tab' => Controls_Manager::TAB_CONTENT
			]
		);

        $this->add_control(
            'navigation',
            [
                'type' => Controls_Manager::SWITCHER,
                'label' => __( 'Arrows', 'spirit' ),
                'default' => 'yes',
                'label_off' => __( 'Hide', 'spirit' ),
                'label_on' => __( 'Show', 'spirit' ),
                'frontend_available' => true,
                'prefix_class' => 'sf-arrows--',
                'render_type' => 'template',
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'pagination',
            [
                'label' => __( 'Pagination', 'spirit' ),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    '' => __( 'None', 'spirit' ),
                    'bullets' => __( 'Dots', 'spirit' ),
                ],
                'prefix_class' => 'sf-pagination--type-',
                'render_type' => 'template',
                'frontend_available' => true
            ]
        );

		$this->add_control(
			'autoplay',
			[
				'label' => __( 'Autoplay', 'spirit' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'separator' => 'before'
			]
		);

		$this->add_control(
			'autoplay_speed',
			[
				'label' => __( 'Autoplay Speed', 'spirit' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 5000,
				'condition' => [
					'autoplay' => 'yes'
				]
			]
		);

		$this->add_control(
			'loop',
			[
				'label' => __( 'Infinite Loop', 'spirit' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);

        $this->add_control(
            'fade',
            [
                'label' => __( 'Fade', 'spirit' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'condition' => [
                    'slides_to_show' => '1'
                ]
            ]
        );

		$this->add_control(
			'speed',
			[
				'label' => __( 'Animation Speed', 'spirit' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 300
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_items_style',
			[
				'label' => __( 'Content', 'spirit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'alignment',
			[
				'label' => __( 'Alignment', 'spirit' ),
				'type' => Controls_Manager::CHOOSE,
				'label_block' => false,
				'default' => 'left',
				'options' => [
					'left' => [
						'title' => __( 'Left', 'spirit' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'spirit' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'spirit' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'prefix_class' => 'sf-testimonial--align-',
			]
		);

		$this->add_responsive_control(
			'padding',
			[
				'label' => __( 'Padding', 'spirit' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .sf-testimonial__content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'content_bg_color',
			[
				'label' => __( 'Background Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-testimonial' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'spirit' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .sf-testimonial' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .sf-swiper-container-bg' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->add_control(
			'show_shadow_bg',
			[
				'label' => __( 'Show Shadow Background', 'spirit' ),
				'type'  => Controls_Manager::SWITCHER,
				'default' => 'no',
				'separator' => 'before'
			]	
		);

		$this->add_control(
			'content_color',
			[
				'label' => __( 'Text Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-testimonial__text' => 'color: {{VALUE}}',
				],
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'selector' => '{{WRAPPER}} .sf-testimonial__text',
			]
		);

		$this->add_control(
			'name_style',
			[
				'label' => __( 'Name', 'spirit' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'name_color',
			[
				'label' => __( 'Text Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-testimonial__name' => 'color: {{VALUE}}',
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'name_typography',
				'selector' => '{{WRAPPER}} .sf-testimonial__name',
			]
		);

        $this->add_responsive_control(
            'name_spacing',
            [
                'label' => __( 'Spacing', 'spirit' ),
                'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100
					]
				],
				'selectors' => [
					'{{WRAPPER}} .sf-testimonial__cite' => 'margin-top: {{SIZE}}{{UNIT}};'
				]
            ]
        );

		$this->add_control(
			'title_style',
			[
				'label' => __( 'Title', 'spirit' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => __( 'Text Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-testimonial__title' => 'color: {{VALUE}}',
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .sf-testimonial__title'
			]
		);

        $this->add_responsive_control(
            'title_spacing',
            [
                'label' => __( 'Spacing', 'spirit' ),
                'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100
					]
				],
				'selectors' => [
					'{{WRAPPER}} .sf-testimonial__title' => 'margin-top: {{SIZE}}{{UNIT}};'
				]
            ]
        );

		$this->end_controls_section();

        $this->register_navigation_style_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		if ( empty( $settings['items'] ) ) {
			return;
		}

		// use unique id selector
        $prev_btn_id = uniqid();
        $next_btn_id = uniqid();
        $pagination_id = uniqid();
        $settings['prev_btn_selector'] = '#sf-swiper-btn-'. $prev_btn_id;
        $settings['next_btn_selector'] = '#sf-swiper-btn-'. $next_btn_id;
        $settings['pagination_selector'] = '#sf-swiper-pagination-'. $pagination_id;

		?>
		<div class="sf-testimonials-carousel clearfix">
			<div class="sf-swiper-container">
				<div class="swiper" data-settings='<?php echo wp_json_encode( $this->get_slider_settings( $settings ) ); ?>'>
					<div class="swiper-wrapper">
					<?php foreach ( $settings['items'] as $item ) : ?>
						<div class="swiper-slide">
							<div class="sf-testimonial">
								<?php if ( $item['image']['url'] ) : ?>
									<div class="sf-testimonial__image">
										<?php echo wp_get_attachment_image( $item['image']['id'], 'full' ); ?>
									</div>
								<?php endif; ?>
								<div class="sf-testimonial__content">
									<div class="sf-testimonial__text">
										<?php echo esc_html( $item['content'] ); ?>
									</div>
									<cite class="sf-testimonial__cite">
									<?php if ( ! empty( $item['name'] ) ) : ?>
										<h4 class="sf-testimonial__name"><?php echo esc_html( $item['name'] ); ?></h4>
									<?php endif; ?>
									<?php if ( ! empty( $item['title'] ) ) : ?>
										<span class="sf-testimonial__title"><?php echo esc_html( $item['title'] ); ?></span>
									<?php endif; ?>
									</cite>
								</div>
							</div>
						</div>
					<?php endforeach; ?>
					</div>
				</div>
				<?php $this->slider_navigation( $settings ); ?>
				<?php if ( isset( $settings['show_shadow_bg'] ) && 'yes' === $settings['show_shadow_bg'] ) : ?>
					<div class="sf-swiper-container-bg"></div>
				<?php endif; ?>
			</div>
		</div>
		<?php
	}

    /**
     * Get slider settings
     * @param  array $settings  widget settings
     * @return array            slider settings
     */
    public function get_slider_settings( $settings ) {
        $slider_settings = [];

		$slider_settings['handleElementorBreakpoints'] = true;
        $slider_settings['autoHeight'] = true;
        $slider_settings['watchOverflow'] = true;
        $slider_settings['slidesPerView'] = 1;
        $slider_settings['slidesToScroll'] = 1;
        $slider_settings['loop'] = ( $settings['loop'] == 'yes' );
        $slider_settings['speed'] = isset( $settings['speed'] ) ? $settings['speed'] : 300;
        
        if ( 'yes' == $settings['autoplay'] ) {
        	if ( !empty( $settings['autoplay_speed'] ) ) {
        		$slider_settings['autoplay'] = [
        			'delay' => intval( $settings['autoplay_speed'] )
        		];
        	} else {
        		$slider_settings['autoplay'] = true;
        	}
        }

        if ( 'yes' == $settings['fade'] ) {
        	$slider_settings['effect'] = 'fade';
        }

        if ( !empty( $settings['navigation'] ) ) {
            $slider_settings['navigation'] = [
            	'prevEl' => $settings['prev_btn_selector'],
                'nextEl' => $settings['next_btn_selector'],
            ];
        }

        if ( 'bullets' == $settings['pagination'] ) {
            $slider_settings['pagination'] = [
                'el' => $settings['pagination_selector'],
                'clickable' => true,
                'type' => 'bullets',
            ];
        }
        
        return $slider_settings;
	}
}

Plugin::instance()->widgets_manager->register( new SF_Testimonials_Carousel() );