<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.


class SF_Team_Members extends SF_Slider_Base {

 	private static $social_icon_classes = array();

	public function get_name() {
		return 'sf-team-members';
	}

	public function get_title() {
		return __( 'Team Members', 'spirit' );
	}

	public function get_icon() {
		return 'eicon-person sf-addons-label';
	}
	
	protected function register_controls() {

  		$this->start_controls_section(
  			'section_general',
  			[
  				'label' => esc_html__( 'General', 'spirit' )
  			]
  		);

        $this->add_control(
            'layout',
            [
                'label' => esc_html__( 'Layout', 'spirit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'carousel' => esc_html__( 'Carousel', 'spirit' ),
                    'grid' => esc_html__( 'Grid', 'spirit' ),
                ],
                'default' => 'grid',
            ]
        );

        $this->add_responsive_control(
            'columns',
            [
                'label' => esc_html__( 'Columns', 'spirit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    1 => esc_html__( '1', 'spirit' ),
                    2 => esc_html__( '2', 'spirit' ),
                    3 => esc_html__( '3', 'spirit' ),
                    4 => esc_html__( '4', 'spirit' ),
                    6 => esc_html__( '6', 'spirit' ),
                    '' => esc_html__( 'Default', 'spirit' ),
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'desktop_default' => 3,
                'tablet_default' => 2,
                'mobile_default' => 1,
                'condition' => [
                    'layout!' => 'carousel',
                ]
            ]
        );

		$this->add_control(
			'show_description',
			[
				'label' => __( 'Show Description', 'spirit' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'description_limit',
			[
				'label' => __( 'Description Limit', 'spirit' ),
				'description' => __( 'Number of characters', 'spirit' ),
				'type' => Controls_Manager::NUMBER
			]
		);

		$this->add_control(
			'show_social_links',
			[
				'label' => __( 'Show Social Links', 'spirit' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

        $this->start_controls_section(
            'section_items',
            [
                'label' => esc_attr__( 'Items', 'spirit' ),
            ]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'user_id',
			[
				'label' => __( 'User ID', 'spirit' ),
				'description' => __( 'This option will pull member data from Wordpress profile.', 'spirit' ),
				'type' => Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'name',
			[
				'label' => __( 'Name', 'spirit' ),
				'type' => Controls_Manager::TEXT,
				'default' => 'John Doe',
			]
		);

		$repeater->add_control(
			'job_title',
			[
				'label' => __( 'Job Position', 'spirit' ),
				'type' => Controls_Manager::TEXT,
				'default' => 'Web Designer',
			]
		);
		
		$repeater->add_control(
			'description',
			[
				'label' => __( 'Description', 'spirit' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => 'Add team member description here.',
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'image',
			[
				'label' => __( 'Image', 'spirit' ),
				'type'  => Controls_Manager::MEDIA,
			]
		);

		$repeater->add_control(
			'link',
			[
				'label' => __( 'Link To', 'spirit' ),
				'type' => Controls_Manager::URL,
				'dynamic' => [
					'active' => true
				]
			]
		);

		$repeater->add_control(
			'social_links_heading',
			[
				'label'       => __('Social Links', 'spirit'),
				'type'        => Controls_Manager::HEADING,
				'separator'   => 'before',
			]
		);

		$repeater->add_control(
			'facebook_url',
			[
				'label'       => __( 'Facebook', 'spirit' ),
				'type'        => Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'twitter_url',
			[
				'label'       => __( 'Twitter', 'spirit' ),
				'type'        => Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'google_plus_url',
			[
				'label'       => __( 'Google+', 'spirit' ),
				'type'        => Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'linkedin_url',
			[
				'label'       => __( 'Linkedin', 'spirit' ),
				'type'        => Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'instagram_url',
			[
				'label'       => __( 'Instagram', 'spirit' ),
				'type'        => Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'youtube_url',
			[
				'label'       => __( 'YouTube', 'spirit' ),
				'type'        => Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'pinterest_url',
			[
				'label'       => __( 'Pinterest', 'spirit' ),
				'type'        => Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'dribbble_url',
			[
				'label'       => __( 'Dribbble', 'spirit' ),
				'type'        => Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'email',
			[
				'label'       => __( 'Email', 'spirit' ),
				'type'        => Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'phone',
			[
				'label'       => __( 'Phone', 'spirit' ),
				'type'        => Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'items',
			[
				'label' => __( 'Team Members', 'spirit' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'name' => 'John Doe',
						'job_title' => 'CEO',
						'description' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.'
					],
					[
						'name' => 'Jane Roe',
						'job_title' => 'CEO',
						'description' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.'
					],
					[
						'name' => 'Sarah Smith',
						'job_title' => 'CEO',
						'description' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.'
					]
				],
				'title_field' => '{{{ name }}}',
			]
		);

        $this->end_controls_section();

		$this->register_slider_controls_section( [ 'layout' => 'carousel'] );
		
		$this->start_controls_section(
			'section_styles_general',
			[
				'label' => esc_html__( 'Team Members', 'spirit' ),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_control(
			'style',
			[
				'label' => esc_html__( 'Style', 'spirit' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default' => esc_html__( 'Default', 'spirit' ),
					'1' => esc_html__( 'Image Left', 'spirit' ),
					'2' => esc_html__( 'Image Right', 'spirit' ),
					'3' => esc_html__( 'Overlay 1', 'spirit' ),
					'4' => esc_html__( 'Overlay 2', 'spirit' )
				],
				'prefix_class' => 'sf-team-member--style-',
				'render_type' => 'template'
			]
		);

		$this->add_control(
			'h_alignment',
			[
				'label' => esc_html__( 'Horizontal Alignment', 'spirit' ),
				'type' => Controls_Manager::CHOOSE,
				'label_block' => true,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'spirit' ),
						'icon' => 'eicon-h-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'spirit' ),
						'icon' => 'eicon-h-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'spirit' ),
						'icon' => 'eicon-h-align-right',
					],
				],
				'default' => 'center',
				'prefix_class' => 'sf-align-',
			]
		);

		$this->add_control(
			'v_alignment',
			[
				'label' => __( 'Vertical Alignment', 'spirit' ),
				'type' => Controls_Manager::CHOOSE,
				'label_block' => false,
				'options' => [
					'top' => [
						'title' => __( 'Top', 'spirit' ),
						'icon' => 'eicon-v-align-top',
					],
					'middle' => [
						'title' => __( 'Middle', 'spirit' ),
						'icon' => 'eicon-v-align-middle',
					],
					'bottom' => [
						'title' => __( 'Bottom', 'spirit' ),
						'icon' => 'eicon-v-align-bottom',
					],
				],
				'default' => 'top',
				'selectors_dictionary' => [
					'top' => 'flex-start',
					'middle' => 'center',
					'bottom' => 'flex-end',
				],
				'selectors' => [
					'{{WRAPPER}} .sf-team-member__inner,{{WRAPPER}} .swiper-container-autoheight .swiper-wrapper' => '-webkit-box-align: {{VALUE}};-ms-flex-align: {{VALUE}};align-items: {{VALUE}};',
					'{{WRAPPER}}.sf-team-member--style-3 .sf-team-member__image + .sf-team-member__content' => '-webkit-box-pack: {{VALUE}};-ms-flex-pack: {{VALUE}};justify-content: {{VALUE}};'
				],
				'condition' => [
					'style!' => 'default',
				],
			]
		);

        $this->add_responsive_control(
            'spacing',
            [
                'label' => __( 'Space Between', 'spirit' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [ 'size' => 30 ],
                'tablet_default' => [ 'size' => 20 ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .row' => 'margin-left: calc( -{{SIZE}}{{UNIT}}/2 ); margin-right: calc( -{{SIZE}}{{UNIT}}/2 );',
                    '{{WRAPPER}} .row [class^=col-]' => 'padding-left: calc( {{SIZE}}{{UNIT}}/2 ); padding-right: calc( {{SIZE}}{{UNIT}}/2 ); margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'render_type' => 'template'
            ]
        );

		$this->add_control(
			'bg_color',
			[
				'label' => esc_html__( 'Background Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-team-member' => 'background: {{VALUE}};',
				]
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'border',
				'label' => esc_html__( 'Border', 'spirit' ),
				'selector' => '{{WRAPPER}} .sf-team-member',
				'separator' => 'before'
			]
		);

		$this->add_responsive_control(
			'border_radius',
			[
				'label' => __( 'Border Radius', 'spirit' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .sf-team-member' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_control(
			'show_shadow_bg',
			[
				'label' => __( 'Show Shadow Background', 'spirit' ),
				'type'  => Controls_Manager::SWITCHER,
				'default' => 'no',
				'separator' => 'before'
			]	
		);

		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_image_styles',
			[
				'label' => esc_html__( 'Image', 'spirit' ),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);		

		$this->add_responsive_control(
			'image_width',
			[
				'label' => esc_html__( 'Image Width', 'spirit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'size_units' => [ '%', 'px' ],
				'selectors' => [
					'{{WRAPPER}} .sf-team-member__image img' => 'max-width:{{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'image_height',
			[
				'label' => esc_html__( 'Image Height', 'spirit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 500,
					],
				],
				'size_units' => [ '%', 'px' ],
				'selectors' => [
					'{{WRAPPER}} .sf-team-member__image img' => 'height:{{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'image_padding',
			[
				'label' => esc_html__( 'Padding', 'spirit' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .sf-team-member__image' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'image_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'spirit' ),
				'type' => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .sf-team-member__image img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
				],
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'section_content_style',
			[
				'label' => esc_html__( 'Content', 'spirit' ),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_control(
			'content_bg_color',
			[
				'label' => esc_html__( 'Background Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-team-member__content' => 'background: {{VALUE}};'
				]
			]
		);

		$this->add_control(
			'content_hover_bg_color',
			[
				'label' => esc_html__( 'Background Hover Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-team-member:hover .sf-team-member__content' => 'background: {{VALUE}};',
				]
			]
		);

		$this->add_responsive_control(
			'margin',
			[
				'label' => esc_html__( 'Margin', 'spirit' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .sf-team-member__content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'padding',
			[
				'label' => esc_html__( 'Padding', 'spirit' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .sf-team-member__content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
            'height',
            [
                'label' => esc_html__( 'Height', 'spirit' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 600,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .sf-team-member__desc' => 'min-height: {{SIZE}}{{UNIT}};',
                ]
            ]
        );

		$this->add_control(
			'name_heading',
			[
				'label' => __( 'Name', 'spirit' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'name_color',
			[
				'label' => esc_html__( 'Text Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-team-member__name' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
             'name' => 'name_typography',
				'selector' => '{{WRAPPER}} .sf-team-member__name',
			]
		);

		$this->add_control(
			'position_heading',
			[
				'label' => __( 'Job Position', 'spirit' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'position_style',
			[
				'label' => esc_html__( 'Style', 'spirit' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'Default', 'spirit' ),
					'1' => esc_html__( 'Style 1', 'spirit' )
				],
			]
		);

		$this->add_control(
			'position_color',
			[
				'label' => esc_html__( 'Text Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-team-member__position' => 'color: {{VALUE}};',
				]
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
             'name' => 'position_typography',
				'selector' => '{{WRAPPER}} .sf-team-member__position',
			]
		);

        $this->add_responsive_control(
            'position_spacing',
            [
                'label' => __( 'Space Between', 'spirit' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [ 'size' => 15 ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .sf-team-member__position' => 'margin-top: {{SIZE}}{{UNIT}};',
                ]
            ]
        );

		$this->add_control(
			'description_heading',
			[
				'label' => __( 'Description', 'spirit' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'description_color',
			[
				'label' => esc_html__( 'Text Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-team-member__desc' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
             'name' => 'description_typography',
				'selector' => '{{WRAPPER}} .sf-team-member__desc',
			]
		);

        $this->add_responsive_control(
            'description_spacing',
            [
                'label' => __( 'Space Between', 'spirit' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [ 'size' => 15 ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .sf-team-member__desc' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'section_social_links_styles',
			[
				'label' => esc_html__( 'Social Icons', 'spirit' ),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);

        $this->add_responsive_control(
            'social_links_spacing',
            [
                'label' => __( 'Space Between', 'spirit' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [ 'size' => 20 ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .sf-team-member__social' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

		$this->add_responsive_control(
			'icon_spacing',
			[
				'label' => esc_html__( 'Spacing', 'spirit' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .sf-team-member__social-link' => 'margin-right: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'icon_size',
			[
				'label' => esc_html__( 'Icon Size', 'spirit' ),
				'type' => Controls_Manager::SLIDER,
				'size_units'	=> [ 'px', '%', 'em' ],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 128,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .sf-team-member__social-link > a' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'icon_height',
			[
				'label' => esc_html__( 'Icon Height', 'spirit' ),
				'type' => Controls_Manager::SLIDER,
				'size_units'	=> [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
					'%'	=> [
						'min'	=> 0,
						'max'	=> 10
					]
				],
				'selectors' => [
					'{{WRAPPER}} .sf-team-member__social-link > a' => 'height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'icon_width',
			[
				'label' => esc_html__( 'Icon Width', 'spirit' ),
				'type' => Controls_Manager::SLIDER,
				'size_units'	=> [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
					'%'	=> [
						'min'	=> 0,
						'max'	=> 10
					]
				],
				'selectors' => [
					'{{WRAPPER}} .sf-team-member__social-link > a' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->start_controls_tabs( 'social_icons_style_tabs' );

		$this->start_controls_tab(
			'normal',
			[ 'label' => esc_html__( 'Normal', 'spirit' ) ]
		);

		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Icon Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-team-member__social-link > a' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'icon_bg_color',
			[
				'label' => esc_html__( 'Background Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .sf-team-member__social-link > a' => 'background-color: {{VALUE}};',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'icon_border',
				'selector' => '{{WRAPPER}} .sf-team-member__social-link > a',
				'separator' => 'before',
			]
		);
		
		$this->add_control(
			'icon_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'spirit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .sf-team-member__social-link > a' => 'border-radius: {{SIZE}}px;',
				],
			]
		);
		
		$this->end_controls_tab();

		$this->start_controls_tab(
			'icon_hover',
			[ 'label' => esc_html__( 'Hover', 'spirit' ) ]
		);

		$this->add_control(
			'icon_hover_color',
			[
				'label' => esc_html__( 'Icon Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-team-member__social-link > a:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'icon_hover_bg_color',
			[
				'label' => esc_html__( 'Background Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .sf-team-member__social-link > a:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'icon_hover_border_color',
			[
				'label' => esc_html__( 'Border Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .sf-team-member__social-link > a:hover' => 'border-color: {{VALUE}};',
				],
			]
		);
		
		$this->end_controls_tab();
		
		$this->end_controls_tabs();

		$this->end_controls_section();

        $this->register_navigation_style_controls_section( [ 'layout' => 'carousel' ] );
	}

	protected function render() {
	  	$settings = $this->get_settings_for_display();
	  	if ( empty( $settings['items'] ) ) {
	  		return;
		}

		?>
		<div class="sf-team-members">
			<div class="clearfix">
            <?php if ( 'carousel' == $settings['layout'] ) :
                // use unique id selector
                $prev_btn_id = uniqid();
                $next_btn_id = uniqid();
                $pagination_id = uniqid();
                $settings['prev_btn_selector'] = '#sf-swiper-btn-'. $prev_btn_id;
                $settings['next_btn_selector'] = '#sf-swiper-btn-'. $next_btn_id;
                $settings['pagination_selector'] = '#sf-swiper-pagination-'. $pagination_id;
                ?>
                <div class="sf-swiper-container">
                    <div class="swiper" data-settings='<?php echo wp_json_encode( $this->get_slider_settings( $settings ) ); ?>'>
                        <div class="swiper-wrapper">
                            <?php foreach ( $settings['items'] as $item ) : ?>
                            <div class="swiper-slide">
                            	<?php $item = $this->get_member_data( $item ); ?>
                            	<?php $this->loop_team_member( $item, $settings ); ?>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
					<?php $this->slider_navigation( $settings ); ?>
					<?php if ( isset( $settings['show_shadow_bg'] ) && 'yes' === $settings['show_shadow_bg'] ) : ?>
						<div class="sf-swiper-container-bg"></div>
					<?php endif; ?>
                </div>
            <?php else:
				$this->add_render_attribute( 'team-member-row', 'class', 'row' );
				$item_class = '';
				$data_animation = sf_get_data_animation_settings( $settings );
				if ( $data_animation ) {
					$this->add_render_attribute( 'team-member-row', 'data-animation-settings', $data_animation );
					$item_class .= 'element-invisible';
				}
				echo '<div ' . $this->get_render_attribute_string( 'team-member-row' ) . '/>';
				?>
                <?php foreach ( $settings['items'] as $item ) : ?>
                    <div class="<?php echo esc_attr( sf_get_column_class( $settings, $item_class ) ); ?>">
                    	<?php $item = $this->get_member_data( $item ); ?>
                    	<?php $this->loop_team_member( $item, $settings ); ?>
                    </div>
               	<?php endforeach; ?>
                </div>
            <?php endif; ?>
			</div>
		</div>
	<?php
	}

	public function loop_team_member( $item, $settings ) {
		if ( false == $item ) {
			return;
		}
		?>
		<div class="sf-team-member">
			<div class="sf-team-member__inner">
				<?php if ( ! empty( $item['image']['id'] ) ) : ?>
					<div class="sf-team-member__image">
						<a href="<?php echo esc_url( $item['link']['url'] ); ?>">
							<?php echo wp_get_attachment_image( $item['image']['id'], 'full' ); ?>
						</a>
					</div>
				<?php elseif ( !empty( $item['image']['url'] ) ) : ?>
					<div class="sf-team-member__image">
						<a href="<?php echo esc_url( $item['link']['url'] ); ?>">
							<img src="<?php echo esc_url( $item['image']['url'] ); ?>" alt="<?php echo esc_attr( $item['name'] ); ?>">
						</a>
					</div>
				<?php endif; ?>
				<div class="sf-team-member__content">
					<h4 class="sf-team-member__name">
						<?php if ( !empty( $item['link']['url'] ) ) :
							$attr = '';
				            if ( $item['link']['is_external'] ) {
				                $attr .= ' target="_blank"';
				            }
				            if ( ! empty( $item['link']['nofollow'] ) ) {
				                $attr .= ' rel="nofollow"';
				            }
						?>
						<a href="<?php echo esc_url( $item['link']['url'] ); ?>" <?php echo $attr; ?>><?php echo esc_html( $item['name'] ); ?></a>
						<?php else : ?>
						<?php echo esc_html( $item['name'] ); ?>
						<?php endif; ?>
					</h4>
					<p class="sf-team-member__position<?php if ( ! empty( $settings['position_style'] ) ) { echo ' style-' . $settings['position_style']; } ?>">
						<span><?php echo $item['job_title']; ?></span>
					</p>
					
					<?php if ( ! empty( $item['description'] && $settings['show_description'] ) ): ?>
					<?php $description = !empty( $settings['description_limit'] ) ? $this->get_short_description( $item['description'], $settings['description_limit'] ) : $item['description']; ?>
						<p class="sf-team-member__desc"><?php echo wp_kses_post( $description ); ?></p>
					<?php endif; ?>
					
					<?php if ( $settings['show_social_links'] ): ?>
					<?php self::$social_icon_classes = sf_get_social_icon_classes(); ?>
					<?php $this->member_social_links( $item ); ?>
					<?php endif; ?>
				</div>
			</div>
		</div>
		<?php
	}

	public function member_social_links( $item ) {
        $facebook_url    = $item['facebook_url'];
        $twitter_url     = $item['twitter_url'];
        $google_plus_url = $item['google_plus_url'];
        $youtube_url     = $item['youtube_url'];
        $instagram_url   = $item['instagram_url'];
        $pinterest_url   = $item['pinterest_url'];
        $linkedin_url    = $item['linkedin_url'];
        $dribbble_url    = $item['dribbble_url'];
        $email    		 = $item['email'];
        $phone    		 = $item['phone'];
        ?>
        <ul class="sf-team-member__social">
        <?php if ( ! empty( $facebook_url ) ) : ?>
            <li class="sf-team-member__social-link"><a href="<?php echo esc_url( $facebook_url ); ?>"><?php $this->social_icon( 'facebook' ); ?></a></li>
        <?php endif; ?>
        <?php if ( ! empty( $twitter_url ) ) : ?>
        	<li class="sf-team-member__social-link"><a href="<?php echo esc_url( $twitter_url ); ?>"><?php $this->social_icon( 'twitter' ); ?></a></li>
        <?php endif; ?>
        <?php if ( ! empty( $google_plus_url ) ) : ?>
        	<li class="sf-team-member__social-link"><a href="<?php echo esc_url( $google_plus_url ); ?>"><?php $this->social_icon( 'googleplus' ); ?></a></li>
        <?php endif; ?>
        <?php if ( ! empty( $youtube_url ) ) : ?>
        	<li class="sf-team-member__social-link"><a href="<?php echo esc_url( $youtube_url ); ?>"><?php $this->social_icon( 'youtube' ); ?></a></li>
        <?php endif; ?>
        <?php if ( ! empty( $instagram_url ) ) : ?>
        	<li class="sf-team-member__social-link"><a href="<?php echo esc_url( $instagram_url ); ?>"><?php $this->social_icon( 'instagram' ); ?></a></li>
        <?php endif; ?>
        <?php if ( ! empty( $pinterest_url ) ) : ?>
        	<li class="sf-team-member__social-link"><a href="<?php echo esc_url( $pinterest_url ); ?>"><?php $this->social_icon( 'pinterest' ); ?></a></li>
        <?php endif; ?>
        <?php if ( ! empty( $linkedin_url ) ) : ?>
        	<li class="sf-team-member__social-link"><a href="<?php echo esc_url( $linkedin_url ); ?>"><?php $this->social_icon( 'linkedin' ); ?></a></li>
        <?php endif; ?>
        <?php if ( ! empty( $dribbble_url ) ) : ?>
        	<li class="sf-team-member__social-link"><a href="<?php echo esc_url( $dribbble_url ); ?>"><?php $this->social_icon( 'dribbble' ); ?></a></li>
		<?php endif; ?>
        <?php if ( ! empty( $email ) ) : ?>
        	<li class="sf-team-member__social-link"><a href="mailto:<?php echo esc_attr( $email ); ?>"><?php $this->social_icon( 'email' ); ?></a></li>
		<?php endif; ?>
        <?php if ( ! empty( $phone ) ) : ?>
        	<li class="sf-team-member__social-link"><a href="tel:<?php echo esc_attr( $phone ); ?>"><?php $this->social_icon( 'phone' ); ?></a></li>
        <?php endif; ?>
        </ul>
        <?php
	}

	public function social_icon( $key ) {
		$icon_classes = self::$social_icon_classes;
		
		if ( isset( $icon_classes[ $key ] ) ) {
			echo '<i class="'. esc_attr( trim( $icon_classes[ $key ] ) ) . '" aria-hidden="true"></i>';
		}
	}

	private function get_member_data( $item ) {
		if ( empty( $item['user_id'] ) ) {
			return $item;
		}
		
		$user_data = get_userdata( $item['user_id'] );
		if ( ! $user_data ) {
			return false;
		}
		$user_avatar 				 = get_user_meta( $user_data->ID, 'sf_user_avatar', true );
		$user_title		 			 = get_user_meta( $user_data->ID, 'sf_user_title', true );
		$user_social_links 			 = get_user_meta( $user_data->ID, 'sf_social_links', true );
		$user_description 			 = get_user_meta( $user_data->ID, 'description', true );
		$user_posts_link 			 = get_author_posts_url( $user_data->ID );
		$item 						 = array();
		$item['name'] 				 = $user_data->display_name;
		$item['job_title'] 			 = $user_title;
		$item['description'] 		 = $user_description;
		$item['image'] 				 = [];
		$item['image']['url'] 		 = $user_avatar;
		$item['link'] 				 = [];
		$item['link']['url'] 		 = $user_posts_link;
		$item['link']['is_external'] = false;
		$item['link']['nofollow'] 	 = true;
		$item['facebook_url'] 		 = isset( $user_social_links['facebook'] ) ? $user_social_links['facebook'] : '';
		$item['twitter_url'] 		 = isset( $user_social_links['twitter'] ) ? $user_social_links['twitter'] : '';
		$item['google_plus_url'] 	 = isset( $user_social_links['googleplus'] ) ? $user_social_links['googleplus'] : '';
		$item['youtube_url'] 		 = isset( $user_social_links['youtube'] ) ? $user_social_links['youtube'] : '';
		$item['instagram_url'] 		 = isset( $user_social_links['instagram'] ) ? $user_social_links['instagram'] : '';
		$item['pinterest_url']		 = isset( $user_social_links['pinterest'] ) ? $user_social_links['pinterest'] : '';
		$item['linkedin_url'] 		 = isset( $user_social_links['linkedin'] ) ? $user_social_links['linkedin'] : '';
		$item['dribbble_url'] 		 = isset( $user_social_links['dribbble'] ) ? $user_social_links['dribbble'] : '';
		$item['email'] 				 = isset( $user_social_links['email'] ) ? $user_social_links['email'] : '';
		$item['phone'] 				 = isset( $user_social_links['phone'] ) ? $user_social_links['phone'] : '';

		return $item;
	}

	public function get_short_description( $description, $limit = 300 ) {
		$limit = absint( $limit );

		if ( mb_strlen( $description ) > $limit ) {
			$description = mb_substr( $description, 0, $limit );
			$description = trim( $description );

			if ( !empty( $description ) ) {
				$description .= '...';
			}
		}

		return $description;
	}
}


Plugin::instance()->widgets_manager->register( new SF_Team_Members() );