<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class SF_Registration_Form extends Widget_Base {

	public function get_name() {
		return 'sf-registration-form';
	}

	public function get_title() {
		return esc_html__( 'Registration Form', 'spirit' );
	}

	public function get_icon() {
		return 'eicon-lock-user sf-addons-label';
	}

    public function get_categories() {
        return [ 'sf-addons' ];
    }

    public function get_keywords() {
        return [ 'sf' ];
	}
	
    public function get_style_depends() {
        return [
            'sf-login'
        ];
    }

    public function get_script_depends() {
        return [
            'sf-login'
        ];
    }

	protected function register_controls() {
		
		$this->start_controls_section(
			'section_general',
			[
				'label' => esc_html__( 'General', 'spirit' ),
			]
		);

		$this->add_control(
			'redirect_after_registration',
			[
				'label' => esc_html__( 'Redirect After Registration', 'spirit' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => ''
			]
		);

		$this->add_control(
			'redirect_url',
			[
				'type' => Controls_Manager::URL,
				'show_label' => false,
				'options' => false,
				'separator' => false,
				'placeholder' => 'https://your-link.com',
				'description' => esc_html__( 'Note: Because of security reasons, you can ONLY use your current domain here.', 'spirit' ),
				'dynamic' => [
					'active' => true,
				],
				'condition' => [
					'redirect_after_registration' => 'yes',
				],
			]
		);

		$this->add_control(
			'show_login',
			[
				'label' => esc_html__( 'Show Login', 'spirit' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'label_off' => esc_html__( 'Hide', 'spirit' ),
				'label_on' => esc_html__( 'Show', 'spirit' )
			]
		);

		$this->add_control(
			'login_url',
			[
				'type' => Controls_Manager::URL,
				'show_label' => false,
				'options' => false,
				'separator' => false,
				'placeholder' => 'https://your-link.com',
				'description' => esc_html__( 'Note: Because of security reasons, you can ONLY use your current domain here.', 'spirit' ),
				'dynamic' => [
					'active' => true,
				],
				'condition' => [
					'show_login' => 'yes'
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_fields',
			[
				'label' => esc_html__( 'Fields', 'spirit' ),
			]
		);

		$this->add_control(
			'custom_labels',
			[
				'label' => esc_html__( 'Custom Label', 'spirit' ),
				'type' => Controls_Manager::SWITCHER,
			]
		);

		$this->add_control(
			'user_placeholder',
			[
				'label' => esc_html__( 'Username Placeholder', 'spirit' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Username', 'spirit' ),
				'condition' => [
					'custom_labels' => 'yes',
				],
				'separator' => 'before',
			]
		);

		$this->add_control(
			'email_placeholder',
			[
				'label' => esc_html__( 'Email Placeholder', 'spirit' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Email', 'spirit' ),
				'condition' => [
					'custom_labels' => 'yes',
				],
				'separator' => 'before',
			]
		);

		$this->add_control(
			'password_placeholder',
			[
				'label' => esc_html__( 'Password Placeholder', 'spirit' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Password', 'spirit' ),
				'condition' => [
					'custom_labels' => 'yes',
				],
			]
		);

		$this->add_control(
			'password2_placeholder',
			[
				'label' => esc_html__( 'Confirm Password Placeholder', 'spirit' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Confirm Password', 'spirit' ),
				'condition' => [
					'custom_labels' => 'yes',
				]
			]
		);

		$this->add_control(
			'icon_user',
			[
				'label' => esc_html__( 'Username', 'spirit' ),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-user',
					'library' => 'solid'
				],
				'separator' => 'before',
			]
		);

		$this->add_control(
			'icon_email',
			[
				'label' => esc_html__( 'Email', 'spirit' ),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-envelope',
					'library' => 'solid'
				],
				'separator' => 'before'
			]
		);

		$this->add_control(
			'icon_password',
			[
				'label' => esc_html__( 'Password', 'spirit' ),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-key',
					'library' => 'solid'
				]
			]
		);

		$this->add_control(
			'icon_show_password',
			[
				'label' => esc_html__( 'Show Password', 'spirit' ),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-eye',
					'library' => 'solid'
				]
			]
		);

		$this->add_control(
			'icon_hide_password',
			[
				'label' => esc_html__( 'Hide Password', 'spirit' ),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-eye-slash',
					'library' => 'solid'
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_button_content',
			[
				'label' => esc_html__( 'Button', 'spirit' ),
			]
		);

		$this->add_control(
			'button_text',
			[
				'label' => esc_html__( 'Text', 'spirit' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Register', 'spirit' ),
			]
		);

		$this->add_control(
			'button_size',
			[
				'label' => esc_html__( 'Size', 'spirit' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'sm' => esc_html__( 'Small', 'spirit' ),
					'md' => esc_html__( 'Medium', 'spirit' ),
					'lg' => esc_html__( 'Large', 'spirit' ),
				],
				'default' => 'lg',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Form', 'spirit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'row_gap',
			[
				'label' => esc_html__( 'Rows Gap', 'spirit' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => '20',
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 60,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .sf-form-row:not(.sf-row-cols-2)' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .sf-form-row .sf-col' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'links_color',
			[
				'label' => esc_html__( 'Links Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-register-form a' => 'color: {{VALUE}};',
				]
			]
		);

		$this->add_control(
			'links_hover_color',
			[
				'label' => esc_html__( 'Links Hover Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-register-form a:hover' => 'color: {{VALUE}};',
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_fields_style',
			[
				'label' => esc_html__( 'Fields', 'spirit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'field_text_color',
			[
				'label' => esc_html__( 'Text Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-form-row input' => 'color: {{VALUE}};',
					'{{WRAPPER}} .sf-hide-pw' => 'color: {{VALUE}};'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'field_typography',
				'selector' => '{{WRAPPER}} .sf-form-row input',
			]
		);

		$this->add_control(
			'field_icon_color',
			[
				'label' => esc_html__( 'Icon Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-form-row i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .sf-form-row svg' => 'color: {{VALUE}};'
				]
			]
		);

		$this->add_control(
			'field_bg_color',
			[
				'label' => esc_html__( 'Background Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .sf-form-row input' => 'background-color: {{VALUE}};',
				],
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'field_padding',
			[
				'label' => esc_html__( 'Padding', 'spirit' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .sf-form-row input' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before'
			]
        );

		$this->add_control(
			'field_border_color',
			[
				'label' => esc_html__( 'Border Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-form-row input:not(:focus)' => 'border-color: {{VALUE}}!important;',
				],
				'separator' => 'before',
			]
		);

		$this->add_control(
			'field_border_active_color',
			[
				'label' => esc_html__( 'Border Active Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-form-row input:focus' => 'border-color: {{VALUE}}!important;',
					'{{WRAPPER}} .sf-form-row input.active' => 'border-color: {{VALUE}}!important;',
				],
			]
		);

		$this->add_control(
			'field_border_width',
			[
				'label' => esc_html__( 'Border Width', 'spirit' ),
				'type' => Controls_Manager::DIMENSIONS,
				'placeholder' => '1',
				'size_units' => [ 'px' ],
				'selectors' => [
					'{{WRAPPER}} .sf-form-row input' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_control(
			'field_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'spirit' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .sf-form-row input' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_button_style',
			[
				'label' => esc_html__( 'Button', 'spirit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->start_controls_tabs( 'tabs_button_style' );

		$this->start_controls_tab(
			'tab_button_normal',
			[
				'label' => esc_html__( 'Normal', 'spirit' ),
			]
		);

		$this->add_control(
			'button_text_color',
			[
				'label' => esc_html__( 'Text Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} button[type=submit]' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'button_typography',
				'selector' => '{{WRAPPER}} button[type=submit]',
			]
		);

		$this->add_control(
			'button_background_color',
			[
				'label' => esc_html__( 'Background Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} button[type=submit]' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(), [
				'name' => 'button_border',
				'selector' => '{{WRAPPER}} button[type=submit]',
				'separator' => 'before',
			]
		);

		$this->add_control(
			'button_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'spirit' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} button[type=submit]' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'button_text_padding',
			[
				'label' => esc_html__( 'Text Padding', 'spirit' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} button[type=submit]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => esc_html__( 'Hover', 'spirit' ),
			]
		);

		$this->add_control(
			'button_hover_color',
			[
				'label' => esc_html__( 'Text Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} button[type=submit]:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_background_hover_color',
			[
				'label' => esc_html__( 'Background Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} button[type=submit]:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_hover_border_color',
			[
				'label' => esc_html__( 'Border Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} button[type=submit]:hover' => 'border-color: {{VALUE}};',
				],
				'condition' => [
					'button_border_border!' => '',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings();
		$registration_redirect_url = '';
		
		if ( 'yes' == $settings['redirect_after_registration'] && ! empty( $settings['redirect_url']['url'] ) ) {
			$registration_redirect_url = $settings['redirect_url']['url'];
		}

		if ( 'yes' == $settings['custom_labels'] ) {
			$placeholder_username  = $settings['user_placeholder'];
			$placeholder_email 	   = $settings['email_placeholder'];
			$placeholder_password  = $settings['password_placeholder'];
			$placeholder_password2 = $settings['password2_placeholder'];
		} else {
			$placeholder_username  = __( 'Username', 'spirit' );
			$placeholder_email 	   = __( 'Email', 'spirit' );
			$placeholder_password  = __( 'Password', 'spirit' );
			$placeholder_password2 = __( 'Confirm Password', 'spirit' );
		}

		if ( 'md' !== $settings['button_size'] ) {
			$this->add_render_attribute( 'button', 'class', 'btn-' . $settings['button_size'] );
		}

		if ( ! empty( $settings['icon_user'] ) ) {
			ob_start();
			Icons_Manager::render_icon( $settings['icon_user'], [ 'aria-hidden' => 'true' ] );
			$user_icon = ob_get_clean();
		} else {
			$user_icon = '<i class="fas fa-user" aria-hidden="true"></i>';
			$user_icon = sf_form_icon( 'username' );
		}

		$show_password_icon = ! empty( $settings['icon_show_password']['value'] ) ? $settings['icon_show_password']['value'] : sf_get_form_icon_class( 'show_password' );
		$hide_password_icon = ! empty( $settings['icon_hide_password']['value'] ) ? $settings['icon_hide_password']['value'] : sf_get_form_icon_class( 'hide_password' ); 

		$this->add_render_attribute( 'button', 'type', 'submit' );
		$this->add_render_attribute( 'button', 'class', [
			'btn',
			'btn-primary',
			'btn-block'
		] );

		?>
		<form method="post" action="<?php echo wp_registration_url(); ?>" class="sf-register-form" data-min-pass-strength="<?php echo esc_attr( apply_filters( 'sf_minimum_password_strength', '3' ) ); ?>" data-redirect="<?php echo esc_url( $registration_redirect_url ); ?>">
	
			<?php do_action( 'sf_register_form_start' ); ?>
			
			<div class="sf-form-message"></div>
			
			<?php if ( SF()->get_setting( 'new_account_first_last_name' ) ) : ?>
				
				<div class="sf-form-row sf-row-cols-2">
					<div class="sf-col">
						<?php echo $user_icon; ?>
						<input type="text" name="sf-firstname" class="sf-firstname validate" placeholder="<?php esc_html_e( 'First name', 'spirit' ); ?>">
					</div>
					<div class="sf-col">
						<?php echo $user_icon; ?>
						<input type="text" name="sf-lastname" class="sf-lastname validate" placeholder="<?php esc_html_e( 'Last name', 'spirit' ); ?>">
					</div>
				</div>
			
			<?php endif; ?>
			
			<?php if ( ! SF()->get_setting( 'new_account_generate_username' ) ) : ?>
		
				<div class="sf-form-row">
					<?php echo $user_icon; ?>
					<input type="text" name="sf-username" class="sf-username validate" placeholder="<?php echo esc_attr( $placeholder_username ); ?>">
				</div>
			
			<?php endif; ?>
		
			<div class="sf-form-row">
				<?php if ( ! empty( $settings['icon_email'] ) ) : ?>
				<?php Icons_Manager::render_icon( $settings['icon_email'], [ 'aria-hidden' => 'true' ] ); ?>
				<?php else: ?>
				<?php sf_form_icon( 'email' ); ?>
				<?php endif; ?>
				<input type="text" name="sf-email" class="sf-email validate" placeholder="<?php echo esc_attr( $placeholder_email ); ?>">
			</div>
		
			<?php if ( ! SF()->get_setting( 'new_account_generate_password' ) ) : ?>
			
				<div class="sf-form-row">
					<div class="sf-form-control-wrap sf-form-control-pass">
						<?php if ( ! empty( $settings['icon_password']['value'] ) ) : ?>
						<?php Icons_Manager::render_icon( $settings['icon_password'], [ 'aria-hidden' => 'true' ] ); ?>
						<?php else: ?>
						<?php sf_form_icon( 'password' ); ?>
						<?php endif; ?>
						<input type="password" name="sf-password" class="sf-password validate" placeholder="<?php echo esc_attr( $placeholder_password ); ?>" autocomplete="off" aria-describedby="sf-pw-strength-meter">
						<button type="button" class="sf-hide-pw hide-if-no-js" aria-label="<?php esc_html_e( 'Show password', 'spirit' ); ?>" tab-index="-1">
							<?php
								Icons_Manager::render_icon(
									$settings['icon_show_password'],
									[
										'aria-hidden' => 'true',
										'data-show' => $show_password_icon,
										'data-hide' => $hide_password_icon
									],
									'span'
								);
							?>
						</button>
					</div>
					<?php if ( SF()->get_setting( 'password_strength_meter' ) ) : ?>
						<div class="sf-pw-strength-meter empty" class="hide-if-no-js" aria-live="polite"></div>
					<?php endif; ?>
				</div>
				<div class="sf-form-row">
					<div class="sf-form-control-wrap sf-form-control-pass2">
						<?php if ( ! empty( $settings['icon_password']['value'] ) ) : ?>
						<?php Icons_Manager::render_icon( $settings['icon_password'], [ 'aria-hidden' => 'true' ] ); ?>
						<?php else: ?>
						<?php sf_form_icon( 'password' ); ?>
						<?php endif; ?>
						<input type="password" name="sf-password2" class="sf-password validate" placeholder="<?php echo esc_attr( $placeholder_password2 ); ?>" autocomplete="off" aria-describedby="sf-pw-strength-meter">
						<button type="button" class="sf-hide-pw hide-if-no-js" aria-label="<?php esc_html_e( 'Show password', 'spirit' ); ?>" tab-index="-1">
							<?php
								Icons_Manager::render_icon(
									$settings['icon_show_password'],
									[
										'aria-hidden' => 'true',
										'data-show' => $show_password_icon,
										'data-hide' => $hide_password_icon
									],
									'span'
								);
							?>
						</button>
					</div>
					<?php if ( SF()->get_setting( 'password_strength_meter' ) ) : ?>
						<div class="sf-pw-weak">
							<label for="sf-pw-weak" class="checkbox">
								<input type="checkbox" name="sf-pw-weak" id="sf-pw-weak" class="sf-pw-weak-checkbox" />
								<span><?php esc_html_e( 'Confirm use of weak password', 'spirit' ); ?></span>
							</label>
						</div>
					<?php endif; ?>
				</div>
		
			<?php endif; ?>
		
			<?php do_action( 'sf_register_form' ); ?>
			
			<?php if ( ! empty( SF()->get_setting( 'new_account_agreement_text' ) ) ) : ?>
				
				<div class="sf-form-row">
					<label class="checkbox">
						<input type="checkbox" name="sf-account-agreement" checked required />
						<span><?php echo sf_get_new_account_agreement_text(); ?></span>
					</label>
				</div>
		
			<?php endif; ?>
			
			<button <?php echo $this->get_render_attribute_string( 'button' ); ?>><?php echo esc_html( $settings['button_text'] ); ?></button>
			<input type="hidden" class="sf-register-nonce" name="sf-register-nonce" value="<?php echo wp_create_nonce( 'sf_register_nonce' ); ?>">
		
				<?php
				if ( 'yes' == $settings['show_login'] ) :
					
					if ( ! empty( $settings['login_url']['url'] ) ) {
						$login_url = $settings['login_url']['url'];
					} else {
						$login_url = wp_login_url();
					}
				?>
			
				<div class="sf-bottom-message">
					<?php esc_html_e( 'Already have an account?', 'spirit' ); ?>
					<a href="<?php echo esc_url( $login_url ); ?>"><?php esc_html_e( 'Log In', 'spirit' ); ?></a>
				</div>
			
			<?php endif; ?>

			<?php do_action( 'sf_register_form_end' ); ?>
		
		</form>
		<?php
	}
}

Plugin::instance()->widgets_manager->register( new SF_Registration_Form() );