<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class SF_Process extends Widget_Base {

	public function get_name() {
		return 'sf-process';
	}

	public function get_title() {
		return __( 'Process', 'spirit' );
	}

	public function get_icon() {
		return 'eicon-number-field sf-addons-label';
	}

    public function get_categories() {
        return [ 'sf-addons' ];
    }

	public function get_keywords() {
		return [ 'step', 'process', 'sf' ];
	}

	protected function register_controls() {
		
		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Process', 'spirit' ),
			]
		);

		$this->add_control(
			'title_html_tag',
			[
				'label' => __( 'Title HTML Tag', 'spirit' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
					'div' => 'div',
				],
				'default' => 'h3'
			]
		);

		$this->add_responsive_control(
			'columns',
			[
				'label' => __( 'Columns', 'spirit' ),
				'type' => Controls_Manager::SELECT,
				'default' => '3',
				'tablet_default' => '3',
				'mobile_default' => '1',
				'options' => [
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
				],
				'prefix_class' => 'elementor-grid%s-',
				'frontend_available' => true,
				'selectors' => [
					'.elementor-msie {{WRAPPER}} .sf-process__item' => 'width: calc( 100% / {{SIZE}} )',
				],
			]
		);

        $this->add_control(
            'show_button',
            [
                'label' => __( 'Show Button', 'spirit' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no'
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'section_items',
			[
				'label' => __( 'Items', 'spirit' ),
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'item_title',
			[
				'label' => __( 'Title & Description', 'spirit' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Lorem ipsum dolor sit', 'spirit' ),
				'dynamic' => [
					'active' => true,
				],
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'item_description',
			[
				'label' => __( 'Description', 'spirit' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => __( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit.', 'spirit' ),
				'dynamic' => [
					'active' => true,
				],
				'show_label' => false,
			]
		);

		$repeater->add_control(
			'item_icon_type',
			[
				'label' => esc_html__( 'Icon Type', 'spirit' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'text',
				'label_block' => false,
				'options' => [
					'' => esc_html__( 'None', 'spirit' ),
					'icon' => esc_html__( 'Icon', 'spirit' ),
					'image' => esc_html__( 'Image', 'spirit' ),
					'text' => esc_html__( 'Text', 'spirit' ),
				],
				'separator' => 'before'
			]
		);

		$repeater->add_control(
			'item_icon',
			[
				'label' => __( 'Choose Icon', 'spirit' ),
				'type' => Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'condition' => [
					'item_icon_type' => 'icon'
				]
			]
		);

		$repeater->add_control(
			'item_image',
			[
				'label' => __( 'Choose Image', 'spirit' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'item_icon_type' => 'image'
				]
			]
		);

		$repeater->add_control(
			'item_text',
			[
				'label' => __( 'Text', 'spirit' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( '1', 'spirit' ),
				'label_block' => true,
				'condition' => [
					'item_icon_type' => 'text'
				]
			]
		);

		$repeater->add_control(
			'item_button_text',
			[
				'label' => __( 'Button text', 'spirit' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Read More', 'spirit' ),
				'label_block' => true,
				'separator' => 'before'
			]
		);

		$repeater->add_control(
			'item_button_link',
			[
				'label' => __( 'Button URL', 'spirit' ),
				'type' => Controls_Manager::URL,
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'item_button_style',
			[
				'label' => __( 'Button Style', 'spirit' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'outline-primary',
				'label_block' => true,
				'options' => sf_get_option_button_styles()
			]
		);

		$this->add_control(
			'items',
			[
				'label' => __( 'Process Items', 'spirit' ),
				'type' => Controls_Manager::REPEATER,
				'separator' => 'before',
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'item_title' => __( 'Lorem ipsum dolor sit', 'spirit' ),
						'item_description' => __( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit.', 'spirit' ),
						'item_icon_type' => 'text',
						'item_icon_text' => '1'
					],
					[
						'item_title' => __( 'Lorem ipsum dolor sit', 'spirit' ),
						'item_description' => __( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit.', 'spirit' ),
						'item_icon_type' => 'text',
						'item_icon_text' => '2'
					],
					[
						'item_title' => __( 'Lorem ipsum dolor sit', 'spirit' ),
						'item_description' => __( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit.', 'spirit' ),
						'item_icon_type' => 'text',
						'item_icon_text' => '3'
					]
				],
				'title_field' => '{{{ item_title }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_box_style',
			[
				'label' => __( 'Box', 'spirit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_responsive_control(
			'alignment',
			[
				'label' => __( 'Alignment', 'spirit' ),
				'type' => Controls_Manager::CHOOSE,
				'default' => 'center',
				'options' => [
					'left' => [
						'title' => __( 'Left', 'spirit' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'spirit' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'spirit' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .sf-process__item' => 'text-align: {{VALUE}};',
				],
				'label_block' => false
			]
		);

		$this->add_responsive_control(
			'column_gap',
			[
				'label' => __( 'Columns Gap', 'spirit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .sf-process__container' => 'grid-column-gap: {{SIZE}}{{UNIT}}',
					'.elementor-msie {{WRAPPER}} .sf-process__container' => 'margin: 0 -{{SIZE}}px',
					'.elementor-msie {{WRAPPER}} .sf-process__item' => 'padding-left: calc({{SIZE}}px / 2);padding-right: calc({{SIZE}}px / 2);',
					'{{WRAPPER}} .sf-process__top::after' => 'width: calc(60% + {{SIZE}}px)',
				]
			]
		);

		$this->add_responsive_control(
			'row_gap',
			[
				'label' => __( 'Rows Gap', 'spirit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'frontend_available' => true,
				'selectors' => [
					'{{WRAPPER}} .sf-process__container' => 'grid-row-gap: {{SIZE}}{{UNIT}}',
					'.elementor-msie {{WRAPPER}} .sf-process__item' => 'margin-bottom: {{SIZE}}px',
				],
			]
		);

		$this->add_control(
			'line_color',
			[
				'label' => __( 'Line Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-process__top:after' => 'border-color: {{VALUE}};',
				],
				'separator' => 'before'
			]
		);

		$this->add_control(
			'line_style',
			[
				'label' => __( 'Line Style', 'spirit' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'solid',
				'options' => [
					'none' => __( 'None', 'spirit' ),
					'solid' => _x( 'Solid', 'Border Control', 'spirit' ),
					'double' => _x( 'Double', 'Border Control', 'spirit' ),
					'dotted' => _x( 'Dotted', 'Border Control', 'spirit' ),
					'dashed' => _x( 'Dashed', 'Border Control', 'spirit' ),
					'groove' => _x( 'Groove', 'Border Control', 'spirit' ),
				],
				'prefix_class' => 'sf-process--line-style-',
				'frontend_available' => true
			]
		);

		$this->add_responsive_control(
			'line_height',
			[
				'label' => __( 'Line Height', 'spirit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .sf-process__top:after' => 'border-bottom-width: {{SIZE}}px;',
				]
			]
		);

		$this->add_responsive_control(
			'line_width',
			[
				'label' => __( 'Line Width', 'spirit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .sf-process__top:after' => 'width: calc({{SIZE}}% + 30px);',
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_top_style',
			[
				'label' => __( 'Top', 'spirit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->start_controls_tabs( 'icon_colors' );

		$this->start_controls_tab(
			'icon_colors_normal',
			[
				'label' => __( 'Normal', 'spirit' ),
			]
		);

		$this->add_control(
			'primary_color',
			[
				'label' => __( 'Primary Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .sf-process__icon' => 'color: {{VALUE}};'
				]
			]
		);

		$this->add_control(
			'secondary_color',
			[
				'label' => __( 'Secondary Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .sf-process__icon' => 'background-color: {{VALUE}};'
				]
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'icon_colors_hover',
			[
				'label' => __( 'Hover', 'spirit' ),
			]
		);

		$this->add_control(
			'hover_primary_color',
			[
				'label' => __( 'Primary Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .sf-process__icon:hover' => 'color: {{VALUE}};'
				]
			]
		);

		$this->add_control(
			'hover_secondary_color',
			[
				'label' => __( 'Secondary Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .sf-process__icon:hover' => 'background-color: {{VALUE}};'
				]
			]
		);

		$this->add_control(
			'hover_animation',
			[
				'label' => __( 'Hover Animation', 'spirit' ),
				'type' => Controls_Manager::HOVER_ANIMATION,
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_responsive_control(
			'icon_space',
			[
				'label' => __( 'Spacing', 'spirit' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 15,
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .sf-process__top' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					'(mobile){{WRAPPER}} .sf-process__top' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'separator' => 'before'
			]
		);

		$this->add_responsive_control(
			'icon_size',
			[
				'label' => __( 'Size', 'spirit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 6,
						'max' => 300,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .sf-process__icon' => 'font-size: {{SIZE}}{{UNIT}};',
				]
			]
		);

		$this->add_control(
			'icon_padding',
			[
				'label' => __( 'Padding', 'spirit' ),
				'type' => Controls_Manager::SLIDER,
				'selectors' => [
					'{{WRAPPER}} .sf-process__icon' => 'padding: {{SIZE}}{{UNIT}};',
				],
				'range' => [
					'em' => [
						'min' => 0,
						'max' => 5,
					]
				]
			]
		);

		$this->add_control(
			'icon_border_radius',
			[
				'label' => __( 'Border Radius', 'spirit' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .sf-process__icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);


		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_style',
			[
				'label' => __( 'Content', 'spirit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => __( 'Title Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-process__title' => 'color: {{VALUE}};',
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .sf-process__title'
			]
		);

		$this->add_control(
			'description_color',
			[
				'label' => __( 'Description Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-process__description' => 'color: {{VALUE}};',
				],
				'separator' => 'before'
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'desc_typography',
				'selector' => '{{WRAPPER}} .sf-process__description'
			]
		);

		$this->add_responsive_control(
			'description_space',
			[
				'label' => __( 'Spacing', 'spirit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .sf-process__description' => 'margin-top: {{SIZE}}{{UNIT}};',
					'(mobile){{WRAPPER}} .sf-process__description' => 'margin-top: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$item_class = '';
		$this->add_render_attribute( 'process-container', 'class', 'elementor-grid sf-process__container' );
		$data_animation = sf_get_data_animation_settings( $settings );
		if ( $data_animation ) {
			$this->add_render_attribute( 'process-container', 'data-animation-settings', $data_animation );
			$item_class .= ' element-invisible';
		}
		?>
		<div class="sf-process">
			<?php
			echo '<div ' . $this->get_render_attribute_string( 'process-container' ) . '/>';
			foreach ( $settings['items'] as $index => $item ) :
				$item_title_setting_key 	  = $this->get_repeater_setting_key( 'item_title', 'items', $index );
				$item_description_setting_key = $this->get_repeater_setting_key( 'item_description', 'items', $index );
				$item_button_setting_key 	  = $this->get_repeater_setting_key( 'item_button', 'items', $index );

				$this->add_render_attribute( $item_title_setting_key, [ 'class' => [ 'sf-process__title' ] ] );
				$this->add_inline_editing_attributes( $item_description_setting_key, 'advanced' );

				if ( 'yes' === $settings['show_button'] ) {
					$this->add_render_attribute( $item_button_setting_key, 'class', [
						'btn',
						! empty( $item['item_button_style'] ) ? 'btn-'. $item['item_button_style'] : 'btn-primary'
					] );

					if ( ! empty( $item['item_button_link']['url'] ) ) {
						$this->add_render_attribute( $item_button_setting_key, 'href', $item['item_button_link']['url'] );

						if ( ! empty( $item['item_button_link']['is_external'] ) ) {
							$this->add_render_attribute( $item_button_setting_key, 'target', '_blank' );
						}
					}
				}
				?>
				<div class="sf-process__item <?php echo esc_attr( $item_class ); ?>">
					<div class="sf-process__top">
						<?php
						if ( 'icon' == $item['item_icon_type'] && ! empty( $item['item_icon'] ) ) {
							echo '<span class="sf-process__icon elementor-animation-' . $settings['hover_animation'] . '">';
							Icons_Manager::render_icon( $item['item_icon'], [ 'aria-hidden' => 'true' ] );
							echo '</span>';
						} else if ( 'image' == $item['item_icon_type'] && ! empty( $item['item_image']['id'] ) ) {
							echo '<span class="sf-process__image">';
							echo wp_get_attachment_image( $item['item_image']['id'], 'full' );
							echo '</span>';
						} else if ( 'text' == $item['item_icon_type'] && ! empty( $item['item_text'] ) ) {
							echo '<span class="sf-process__icon">';
							echo '<i>' . esc_html( $item['item_text'] ) . '</i>';
							echo '</span>';
						}
						?>
					</div>
					<div class="sf-process__content">
						<<?php echo $settings['title_html_tag']; ?> <?php echo $this->get_render_attribute_string( $item_title_setting_key ); ?>>
							<?php echo $item['item_title']; ?>
						</<?php echo $settings['title_html_tag']; ?>>
						<?php if ( ! empty( $item['item_description'] ) ) : ?>
							<div class="sf-process__description">
								<?php echo $this->parse_text_editor( $item['item_description'] ); ?>
							</div>
						<?php endif; ?>
						<?php if ( 'yes' === $settings['show_button'] && ! empty( $item['item_button_text'] ) ) : ?>
							<div class="sf-process__button">
								<a <?php echo $this->get_render_attribute_string( $item_button_setting_key ); ?>><?php echo esc_html( $item['item_button_text'] ); ?></a>
							</div>
						<?php endif; ?>
					</div>
				</div>
			<?php endforeach; ?>
			</div>
		</div>
		<?php
	}
}

Plugin::instance()->widgets_manager->register( new SF_Process() );