<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class SF_Login_Form extends Widget_Base {

	public function get_name() {
		return 'sf-login-form';
	}

	public function get_title() {
		return esc_html__( 'Login Form', 'spirit' );
	}

	public function get_icon() {
		return 'eicon-lock-user sf-addons-label';
	}

    public function get_categories() {
        return [ 'sf-addons' ];
    }

    public function get_keywords() {
        return [ 'sf' ];
	}
	
    public function get_style_depends() {
        return [
            'sf-login'
        ];
    }

    public function get_script_depends() {
        return [
            'sf-login'
        ];
    }

	protected function register_controls() {
		
		$this->start_controls_section(
			'section_general',
			[
				'label' => esc_html__( 'General', 'spirit' ),
			]
		);

		$this->add_control(
			'redirect_after_login',
			[
				'label' => esc_html__( 'Redirect After Login', 'spirit' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => ''
			]
		);

		$this->add_control(
			'redirect_url',
			[
				'type' => Controls_Manager::URL,
				'show_label' => false,
				'options' => false,
				'separator' => false,
				'placeholder' => 'https://your-link.com',
				'description' => esc_html__( 'Note: Because of security reasons, you can ONLY use your current domain here.', 'spirit' ),
				'dynamic' => [
					'active' => true,
				],
				'condition' => [
					'redirect_after_login' => 'yes',
				],
			]
		);

		$this->add_control(
			'show_remember_me',
			[
				'label' => esc_html__( 'Remember Me', 'spirit' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'label_off' => esc_html__( 'Hide', 'spirit' ),
				'label_on' => esc_html__( 'Show', 'spirit' ),
			]
		);

		$this->add_control(
			'show_lost_password',
			[
				'label' => esc_html__( 'Lost your password?', 'spirit' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'label_off' => esc_html__( 'Hide', 'spirit' ),
				'label_on' => esc_html__( 'Show', 'spirit' ),
			]
		);

		$this->add_control(
			'lost_password_url',
			[
				'type' => Controls_Manager::URL,
				'show_label' => false,
				'options' => false,
				'separator' => false,
				'placeholder' => 'https://your-link.com',
				'description' => esc_html__( 'Note: Because of security reasons, you can ONLY use your current domain here.', 'spirit' ),
				'dynamic' => [
					'active' => true,
				],
				'condition' => [
					'show_lost_password' => 'yes',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_fields',
			[
				'label' => esc_html__( 'Fields', 'spirit' ),
			]
		);

		$this->add_control(
			'custom_labels',
			[
				'label' => esc_html__( 'Custom Label', 'spirit' ),
				'type' => Controls_Manager::SWITCHER,
			]
		);

		$this->add_control(
			'user_placeholder',
			[
				'label' => esc_html__( 'Username Placeholder', 'spirit' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Username or Email Address', 'spirit' ),
				'condition' => [
					'custom_labels' => 'yes',
				],
				'separator' => 'before',
			]
		);

		$this->add_control(
			'password_placeholder',
			[
				'label' => esc_html__( 'Password Placeholder', 'spirit' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Password', 'spirit' ),
				'condition' => [
					'custom_labels' => 'yes',
				],
			]
		);

		$this->add_control(
			'icon_user',
			[
				'label' => esc_html__( 'Username', 'spirit' ),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-user',
					'library' => 'solid'
				],
				'separator' => 'before',
			]
		);

		$this->add_control(
			'icon_password',
			[
				'label' => esc_html__( 'Password', 'spirit' ),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-key',
					'library' => 'solid'
				]
			]
		);

		$this->add_control(
			'icon_show_password',
			[
				'label' => esc_html__( 'Show Password', 'spirit' ),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-eye',
					'library' => 'solid'
				]
			]
		);

		$this->add_control(
			'icon_hide_password',
			[
				'label' => esc_html__( 'Hide Password', 'spirit' ),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-eye-slash',
					'library' => 'solid'
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_button_content',
			[
				'label' => esc_html__( 'Button', 'spirit' ),
			]
		);

		$this->add_control(
			'button_text',
			[
				'label' => esc_html__( 'Text', 'spirit' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Log In', 'spirit' ),
			]
		);

		$this->add_control(
			'button_size',
			[
				'label' => esc_html__( 'Size', 'spirit' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'sm' => esc_html__( 'Small', 'spirit' ),
					'md' => esc_html__( 'Medium', 'spirit' ),
					'lg' => esc_html__( 'Large', 'spirit' ),
				],
				'default' => 'lg',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Form', 'spirit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'row_gap',
			[
				'label' => esc_html__( 'Rows Gap', 'spirit' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => '20',
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 60,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .sf-form-row' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'links_color',
			[
				'label' => esc_html__( 'Links Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-login-form a' => 'color: {{VALUE}};',
				]
			]
		);

		$this->add_control(
			'links_hover_color',
			[
				'label' => esc_html__( 'Links Hover Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-login-form a:hover' => 'color: {{VALUE}};',
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_fields_style',
			[
				'label' => esc_html__( 'Fields', 'spirit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'field_text_color',
			[
				'label' => esc_html__( 'Text Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-form-row input' => 'color: {{VALUE}};',
					'{{WRAPPER}} .sf-hide-pw' => 'color: {{VALUE}};'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'field_typography',
				'selector' => '{{WRAPPER}} .sf-form-row input',
			]
		);

		$this->add_control(
			'field_icon_color',
			[
				'label' => esc_html__( 'Icon Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-form-row i' => 'color: {{VALUE}}!important;',
					'{{WRAPPER}} .sf-form-row svg' => 'color: {{VALUE}}!important;'
				]
			]
		);

		$this->add_control(
			'field_bg_color',
			[
				'label' => esc_html__( 'Background Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .sf-form-row input' => 'background-color: {{VALUE}}!important;',
				],
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'field_padding',
			[
				'label' => esc_html__( 'Padding', 'spirit' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .sf-form-row input' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before'
			]
        );

		$this->add_control(
			'field_border_color',
			[
				'label' => esc_html__( 'Border Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-form-row input:not(:focus)' => 'border-color: {{VALUE}};',
				],
				'separator' => 'before',
			]
		);

		$this->add_control(
			'field_border_active_color',
			[
				'label' => esc_html__( 'Border Active Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sf-form-row input:focus' => 'border-color: {{VALUE}};',
					'{{WRAPPER}} .sf-form-row input.active' => 'border-color: {{VALUE}};',
				]
			]
		);

		$this->add_control(
			'field_border_width',
			[
				'label' => esc_html__( 'Border Width', 'spirit' ),
				'type' => Controls_Manager::DIMENSIONS,
				'placeholder' => '1',
				'size_units' => [ 'px' ],
				'selectors' => [
					'{{WRAPPER}} .sf-form-row input' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_control(
			'field_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'spirit' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .sf-form-row input' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_button_style',
			[
				'label' => esc_html__( 'Button', 'spirit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->start_controls_tabs( 'tabs_button_style' );

		$this->start_controls_tab(
			'tab_button_normal',
			[
				'label' => esc_html__( 'Normal', 'spirit' ),
			]
		);

		$this->add_control(
			'button_text_color',
			[
				'label' => esc_html__( 'Text Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} button[type=submit]' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'button_typography',
				'selector' => '{{WRAPPER}} button[type=submit]',
			]
		);

		$this->add_control(
			'button_background_color',
			[
				'label' => esc_html__( 'Background Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} button[type=submit]' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(), [
				'name' => 'button_border',
				'selector' => '{{WRAPPER}} button[type=submit]',
				'separator' => 'before',
			]
		);

		$this->add_control(
			'button_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'spirit' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} button[type=submit]' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'button_text_padding',
			[
				'label' => esc_html__( 'Text Padding', 'spirit' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} button[type=submit]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => esc_html__( 'Hover', 'spirit' ),
			]
		);

		$this->add_control(
			'button_hover_color',
			[
				'label' => esc_html__( 'Text Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} button[type=submit]:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_background_hover_color',
			[
				'label' => esc_html__( 'Background Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} button[type=submit]:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_hover_border_color',
			[
				'label' => esc_html__( 'Border Color', 'spirit' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} button[type=submit]:hover' => 'border-color: {{VALUE}};',
				],
				'condition' => [
					'button_border_border!' => '',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();
	}

	protected function render() {

		if ( ! is_user_logged_in() || Plugin::$instance->editor->is_edit_mode() ) :

			$settings = $this->get_settings();
			
			$login_redirect_url = '';
			if ( 'yes' == $settings['redirect_after_login'] && ! empty( $settings['redirect_url']['url'] ) ) {
				$login_redirect_url = $settings['redirect_url']['url'];
			}

			if ( 'yes' == $settings['custom_labels'] ) {
				$placeholder_username = $settings['user_placeholder'];
				$placeholder_password = $settings['password_placeholder'];
			} else {
				$placeholder_username = __( 'Username or Email Address', 'spirit' );
				$placeholder_password = __( 'Password', 'spirit' );
			}

			$show_password_icon = ! empty( $settings['icon_show_password']['value'] ) ? $settings['icon_show_password']['value'] : sf_get_form_icon_class( 'show_password' );
			$hide_password_icon = ! empty( $settings['icon_hide_password']['value'] ) ? $settings['icon_hide_password']['value'] : sf_get_form_icon_class( 'hide_password' );

			$this->add_render_attribute( 'button', 'type', 'submit' );
			$this->add_render_attribute( 'button', 'class', [
				'btn',
				'btn-primary',
				'btn-block'
			] );

			if ( 'md' !== $settings['button_size'] ) {
				$this->add_render_attribute( 'button', 'class', 'btn-' . $settings['button_size'] );
			}

			?>
			<form method="post" action="<?php echo wp_login_url(); ?>" class="sf-login-form" data-redirect="<?php echo esc_url( $login_redirect_url ); ?>">
				
				<?php do_action( 'sf_login_form_start' ); ?>
				
				<div class="sf-form-message"></div>
				<div class="sf-form-row">
					<?php if ( ! empty( $settings['icon_user'] ) ) : ?>
					<?php Icons_Manager::render_icon( $settings['icon_user'], [ 'aria-hidden' => 'true' ] ); ?>
					<?php else: ?>
				    <?php sf_form_icon( 'username' ); ?>
					<?php endif; ?>
					<input type="text" name="sf-username" class="sf-username validate" placeholder="<?php echo esc_attr( $placeholder_username ); ?>">
				</div>
				<div class="sf-form-row">
					<div class="sf-form-control-wrap">
						<?php if ( ! empty( $settings['icon_password'] ) ) : ?>
						<?php Icons_Manager::render_icon( $settings['icon_password'], [ 'aria-hidden' => 'true' ] ); ?>
						<?php else: ?>
						<?php sf_form_icon( 'password' ); ?>
						<?php endif; ?>
						<input type="password" name="sf-userpass" class="sf-userpass validate" placeholder="<?php echo esc_attr( $placeholder_password ); ?>">
						<button type="button" class="sf-hide-pw hide-if-no-js" aria-label="<?php esc_html_e( 'Show password', 'spirit' ); ?>" tab-index="-1">
							<?php
								Icons_Manager::render_icon(
									$settings['icon_show_password'],
									[
										'aria-hidden' => 'true',
										'data-show' => $show_password_icon,
										'data-hide' => $hide_password_icon
									],
									'span'
								);
							?>
						</button>
					</div>
				</div>
		
				<?php do_action( 'sf_login_form' ); ?>
				
				<?php if ( 'yes' == $settings['show_remember_me'] ) : ?>
					
					<div class="sf-form-row">
						<?php $id_suffix = uniqid(); ?>
						<label for="sf-remember-<?php echo esc_attr( $id_suffix ); ?>" class="checkbox">
							<input type="checkbox" id="sf-remember-<?php echo esc_attr( $id_suffix ); ?>" name="sf-rememberme" class="sf-rememberme">
							<span><?php esc_html_e( 'Remember Me', 'spirit' ); ?></span>
						</label>
					</div>
				
				<?php endif; ?>
				
				<button <?php echo $this->get_render_attribute_string( 'button' ); ?>><?php echo esc_html( $settings['button_text'] ); ?></button>
				<input type="hidden" class="sf-login-nonce" name="sf-login-nonce" value="<?php echo wp_create_nonce( 'sf_login_nonce' ); ?>">
				
					<?php
					if ( 'yes' == $settings['show_lost_password'] ) :
						
						if ( ! empty( $settings['lost_password_url']['url'] ) ) {
							$lost_password_url = $settings['lost_password_url']['url'];
						} else {
							$lost_password_url = wp_lostpassword_url( $login_redirect_url );
						}
					?>
				
					<div class="sf-bottom-message">
						<a href="<?php echo esc_url( $lost_password_url ); ?>"><?php esc_html_e( 'Lost Password?', 'spirit' ); ?></a>
					</div>
				
				<?php endif; ?>

				<?php do_action( 'sf_login_form_end' ); ?>
		
			</form>
		
		<?php endif;
		
	}
}

Plugin::instance()->widgets_manager->register( new SF_Login_Form() );