<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.


class SF_Image_Slider extends SF_Slider_Base {

	public function get_name() {
		return 'sf-image-slider';
	}

	public function get_title() {
		return __( 'Image Slider', 'spirit' );
	}

	public function get_icon() {
		return 'eicon-slider-push sf-addons-label';
	}

    public function get_style_depends() {
        return [
            'fancybox',
            'swiper'
        ];
    }

    public function get_script_depends() {
        return [
            'swiper',
            'fancybox',
            'imagesloaded',
            'sf-frontend'
        ];
    }
	
	protected function register_controls() {

		$this->start_controls_section(
            'section_images',
            [
                'label' => __( 'Images', 'spirit' ),
            ]
        );

        $this->add_control(
            'images',
            [
                'label' => __( 'Add Images', 'spirit' ),
                'type' => Controls_Manager::GALLERY
            ]
		);

		$this->end_controls_section();
		
        $this->start_controls_section(
            'section_settings',
            [
                'label' => __( 'Options', 'spirit' ),
            ]
        );

        $this->add_control(
            'enable_lightbox',
            [
                'type' => Controls_Manager::SWITCHER,
                'label' => __( 'Enable Lightbox Gallery', 'spirit' ),
                'default' => 'yes',
            ]
		);

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'label' => __( 'Gallery Image Size', 'spirit' ),
                'default' => 'large',
            ]
		);

        $this->add_control(
            'center_slides',
            [
                'type' => Controls_Manager::SWITCHER,
                'label' => __( 'Center Slides', 'spirit' ),
                'default' => 'yes',
            ]
		);

        $this->add_responsive_control(
            'spacing',
            [
                'label' => __( 'Space Between', 'spirit' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [ 'size' => 30 ],
                'tablet_default' => [ 'size' => 20 ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
				'render_type' => 'template'
            ]
        );
		
		$this->end_controls_section();

		$this->register_slider_controls_section();

        $this->register_navigation_style_controls_section();
	}

	protected function render() {
	  	$settings = $this->get_settings_for_display();

	  	if ( empty( $settings['images'] ) ) {
	  		return;
		}

		$slide_class = 'swiper-slide';
		if ( 'auto' === $settings['slides_to_show'] ) {
			$slide_class .= ' sf-slide-auto-width';
		}
		
		// use unique id selector
		$prev_btn_id = uniqid();
		$next_btn_id = uniqid();
		$pagination_id = uniqid();
		$settings['prev_btn_selector'] = '#sf-swiper-btn-'. $prev_btn_id;
		$settings['next_btn_selector'] = '#sf-swiper-btn-'. $next_btn_id;
		$settings['pagination_selector'] = '#sf-swiper-pagination-'. $pagination_id;
		?>
		<div class="sf-image-slider">
			<div class="sf-swiper-container">
				<div class="swiper" data-settings='<?php echo wp_json_encode( $this->get_slider_settings( $settings ) ); ?>'>
					<div class="swiper-wrapper">
						<?php foreach ( $settings['images'] as $item ) : ?>
						<div class="<?php echo esc_attr( $slide_class ); ?>">
							<?php if ( 'yes' == $settings['enable_lightbox'] ) : ?>
								<a data-fancybox="sf-gallery-<?php echo esc_attr( $this->get_id() ); ?>" class="sf-lightbox__item" href="<?php echo esc_url( $item['url'] ); ?>" title="<?php echo get_the_title( $item['id'] ); ?>">
									<?php echo wp_get_attachment_image( $item['id'], $settings['thumbnail_size'] ); ?>
								</a>
							<?php else : ?>
								<?php echo wp_get_attachment_image( $item['id'], $settings['thumbnail_size'] ); ?>
							<?php endif; ?>
						</div>
						<?php endforeach; ?>
					</div>
				</div>
				<?php $this->slider_navigation( $settings ); ?>
			</div>
		</div>
		<?php
	}
}


Plugin::instance()->widgets_manager->register( new SF_Image_Slider() );