<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use Elementor\Controls_Manager;

class SF_Animation_Section {

    public static function init() {
        add_action( 'elementor/element/sf-content-block/section_items/after_section_end', [ 'SF_Animation_Section', 'register_section' ], 10 );
        add_action( 'elementor/element/sf-icon-boxes/section_items/after_section_end', [ 'SF_Animation_Section', 'register_section' ], 10 );
        add_action( 'elementor/element/sf-process/section_items/after_section_end', [ 'SF_Animation_Section', 'register_section' ], 10 );
        add_action( 'elementor/element/sf-team-members/section_items/after_section_end', [ 'SF_Animation_Section', 'register_section' ], 10 );
        add_action( 'elementor/element/sf-testimonials/section_items/after_section_end', [ 'SF_Animation_Section', 'register_section' ], 10 );
        add_action( 'elementor/element/sf-image-grid/section_items/after_section_end', [ 'SF_Animation_Section', 'register_section' ], 10 );
		
		$hooks = apply_filters( 'sf_elementor_animation_section_hooks', [] );
        foreach ( $hooks as $hook ) {
            add_action( $hook, [ 'SF_Animation_Section', 'register_section' ], 10 );
        }
    }

    public static function register_section( $element ) {
        $element->start_controls_section(
            'section_animation',
            [
                'label' => __( 'Animation', 'spirit' ),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );

        $element->add_control(
            'animation',
            [
                'label' => esc_html__( 'Entrance Animation', 'spirit' ),
                'type' => Controls_Manager::SELECT,
                'options' => sf_get_option_entrance_animation(),
                'default' => ''
            ]
        );
    
        $element->add_control(
            'animation_speed',
            [
                'label' => esc_html__( 'Animation Speed (ms)', 'spirit' ),
                'type' => Controls_Manager::SELECT,
                'options' => sf_get_option_animation_speed(),
                'default' => '400'
            ]
        );
    
        $element->add_control(
            'animation_delay',
            [
                'label' => esc_html__( 'Animation Delay (ms)', 'spirit' ),
                'type' => Controls_Manager::NUMBER,
            ]
        );

        $element->add_control(
            'animation_on',
            [
                'label' => esc_html__( 'Animation On', 'spirit' ),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => 1,
                'options' => [
                    'desktop' => esc_html__( 'Desktop', 'spirit' ),
                    'tablet' => esc_html__( 'Tablet', 'spirit' ),
                    'mobile' => esc_html__( 'Mobile', 'spirit' )
                ],
                'default' => [ 'desktop', 'tablet', 'mobile' ]
            ]
        );

        $element->end_controls_section();
    }
}

SF_Animation_Section::init();