<?php

/**
 * Display gallery items
 * 
 * @param  array $images   images
 * @param  array $settings widget settings
 */
function sf_display_gallery_items( $images, $settings ) {
    foreach ( $images as $image ) : ?>
        <div class="sf-gallery-item <?php echo esc_attr( $image['tags'] ); ?>" data-colspan="<?php echo esc_attr( $image['colspan'] ); ?>">
            <div class="sf-gallery__image">
                <?php if ( 'yes' == $settings['enable_lightbox'] ) : ?>
                    <a data-fancybox="sf-gallery-<?php echo esc_attr( $settings['gallery_id'] ); ?>" class="sf-lightbox__item" href="<?php echo esc_url( $image['url'] ); ?>" title="<?php echo esc_attr( $image['title'] ); ?>">
                        <?php echo wp_get_attachment_image( $image['id'], $settings['thumbnail_size'] ); ?>
                    </a>
                <?php else : ?>
                <?php echo wp_get_attachment_image( $image['id'], $settings['thumbnail_size'] ); ?>
                <?php endif; ?>
                <div class="sf-gallery-item__overlay"></div>
                <?php if ( ! empty( $image['title'] ) ) : ?>
                    <h4 class="sf-gallery-item__title">
                    <?php if ( ! empty( $image['link']['url'] ) ) : ?>
                        <?php $target = $image['link']['is_external'] ? ' target="_blank"' : ''; ?>
                        <?php $rel = $image['link']['nofollow'] ? ' rel="nofollow"' : ''; ?>
                        <a href="<?php echo esc_url( $image['link']['url'] ); ?>"<?php echo $target; echo $rel; ?>>
                            <?php echo esc_html( $image['title'] ); ?>
                        </a>
                    <?php else : ?>
                        <span><?php echo esc_html( $image['title'] ); ?></span>
                    <?php endif; ?>
                    </h4>
                <?php endif; ?>
            </div>
        </div>
    <?php endforeach;
}