<?php
/**
 * SF Demo Manager
 * 
 */
class SF_Demo_Manager {

	protected static $_instance = null;

	/**
	 * Main instance
	 * Ensures only one instance of this class is loaded or can be loaded.
	 *
	 * @static
	 * @return SF_Demo_Manager - Main instance
	 */
	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	/**
	 * Constructor
	 * @param array $path demo content path
	 */
	function __construct() {
		add_action( 'wp_ajax_sf_install_demo', array( $this, 'install_demo' ) );
		add_action( 'wp_ajax_sf_after_demo_install', array( $this, 'after_demo_install' ) );
		add_filter( 'woocommerce_prevent_automatic_wizard_redirect', '__return_true' );
	}

	/**
	 * Install or remove demo content
	 */
	function install_demo() {
		set_time_limit( 0 );

		$demo_action = isset( $_POST['demo_action'] ) ? sanitize_text_field( $_POST['demo_action'] ) : '';
		$demo_cat = isset( $_POST['demo_cat'] ) ? sanitize_text_field( $_POST['demo_cat'] ) : '';
		$demo_item = isset( $_POST['demo_item'] ) ? sanitize_text_field( $_POST['demo_item'] ) : '';
		$demo_id = isset( $_POST['demo_id'] ) ? sanitize_text_field( $_POST['demo_id'] ) : '';
		
		if ( 'install' == $demo_action ) {
			$current_demo = get_option( 'sf_demo_current' );
			$demo_data = get_option( 'sf_demo_data' );
			$shared_demo_cats = apply_filters( 'sf_config_demo_shared_content', [] );
			$skip_item = false;
			
			if ( ! empty( $current_demo ) ) {
				if ( $current_demo !== $demo_id ) {
					if ( empty( $shared_demo_cats ) ) {
						// remove old demo content
						SF_Demo_Installer::clear_content();
						SF_Demo_Installer::delete_content();
					} else {
						update_option( 'sf_switching_demo', true );
					}
					update_option( 'sf_demo_current', $demo_id );
				}
				
			} else {
				// create backup
				SF_Demo_Installer::create_backup();
				update_option( 'sf_demo_current', $demo_id );
			}

			// do not import shared content
			if ( false != get_option( 'sf_switching_demo' ) && in_array( $demo_cat, $shared_demo_cats ) && ! empty( $demo_data[ $demo_cat ] ) && 'pages' !== $demo_cat ) {
				$skip_item = true;
			}

			if ( ! $skip_item && ! empty( $demo_cat ) && ! empty( $demo_item ) ) {
				$demo_dir = apply_filters( 'sf_config_demos_dir', '' );
				$demo_file = $demo_dir . '/'. $demo_cat .'.php';
				$demo_file = wp_normalize_path( $demo_file );
				if ( ! empty( $demo_file ) && file_exists( $demo_file ) ) {
					include( $demo_file );
				}
			}
			
		} else if ( 'uninstall' == $demo_action ) {
			SF_Demo_Installer::uninstall_demo();
		}

		exit;
	}

	/**
	 * Do things after demo installation
	 *
	 * @return void
	 */
	public function after_demo_install() {
		delete_option( 'sf_switching_demo' );
		do_action( 'sf_demo_after_demo_install' );

		exit;
	}
}

SF_Demo_Manager::instance();