jQuery(document).ready(function ($) {

	// Let's use the API.
	var api = wp.customize;

	syncPreviewButtons();

	/**
	 * Sync device preview button from WordPress to sf and vice versa.
	 */
	function syncPreviewButtons() {
		// Bind device changes from WordPress default.
		api.previewedDevice.bind(function (newDevice) {
			responsivePreview(newDevice);
		});
	}

	/**
	 * Setup device preview.
	 * 
	 * @param string device The device (mobile, tablet, or desktop).
	 * @param bool modifyOverlay Whether or not to modify the wp-full-overlay.
	 */
	function responsivePreview(device) {
		$('.sf-responsive-options button').removeClass('active');
		$('.sf-responsive-options .preview-' + device).addClass('active');
		$('.sf-control-device').removeClass('active');
		$('.sf-control-' + device).addClass('active');
	}

	// Display desktop control by default.
	$('.sf-control-desktop').addClass('active');

	// Loop through sf device buttons and assign the event.
	$('.sf-responsive-options button').on('click', function (e) {
		var device = this.getAttribute('data-device');

		responsivePreview(device);
		// Trigger WordPress device event.
		api.previewedDevice.set(device);
	});

	// Responsive Padding
    $('.sf-responsive-padding-wrap .customize-control-responsive-padding-value').on('keyup change', function () {

        var parent = $(this).parents('.sf-responsive-padding-wrap'),
            dbstore_cache = $('.sf-responsive-padding-db', parent),
            dbstore = dbstore_cache.val(),
            device_type = $(this).data('area-device-type');

        dbstore = dbstore === '' ? {} : JSON.parse(dbstore);

        dbstore[device_type] = this.value;

        dbstore_cache.val(JSON.stringify(dbstore)).change();
    });
	
	// Responsive Inputs
    $('.sf-responsive-input-wrap .customize-control-input-value').on('keyup', function () {

        var parent = $(this).parents('.sf-responsive-input-wrap'),
            dbstore_cache = $('.sf-responsive-input-db', parent),
            dbstore = dbstore_cache.val(),
            device_type = $(this).data('device-type');
		
        dbstore = dbstore === '' ? {} : JSON.parse(dbstore);

        dbstore[device_type] = this.value;

        dbstore_cache.val(JSON.stringify(dbstore)).change();
    });
});
