<?php
/**
 * Enqueue customizer scripts & styles.
 */
function sf_customizer_scripts_styles() {
	wp_enqueue_style( 'sf-customizer', SF_FRAMEWORK_URI . 'includes/customizer/css/customizer.css', false, SF_FRAMEWORK_VERSION );
	wp_enqueue_script( 'sf-responsive-controls', SF_FRAMEWORK_URI . 'includes/customizer/js/responsive-controls.js', array( 'jquery' ), SF_FRAMEWORK_VERSION, true );
}
add_action( 'customize_controls_print_styles', 'sf_customizer_scripts_styles' );

/**
 * Register custom controls
 */
add_action( 'customize_register', function( $wp_customize ) {
    if ( ! defined( 'KIRKI_VERSION' ) ) {
        return;
    }
    require SF_FRAMEWORK_DIR . 'includes/customizer/controls/control-responsive-input.php';
    require SF_FRAMEWORK_DIR . 'includes/customizer/controls/control-responsive-padding.php';

    add_filter( 'kirki_control_types', function ( $controls ) {
        $controls['responsive_input'] = 'SF_Customize_Control_Responsive_Input';
        $controls['responsive_padding'] = 'SF_Customize_Control_Responsive_Padding';
        return $controls;
    } );

    $wp_customize->register_control_type( 'SF_Customize_Control_Responsive_Input' );
    $wp_customize->register_control_type( 'SF_Customize_Control_Responsive_Padding' );
});