<?php
/**
 * Custom responsive padding control.
 *
 * @package Page Builder Framework
 * @subpackage Customizer
 */

defined( 'ABSPATH' ) || exit; // Exit if accessed directly.

class SF_Customize_Control_Responsive_Padding extends Kirki\Control\Base {

	public $type = 'sf-responsive-padding';

	public function render_content() {

		$devices = array( 'desktop', 'tablet', 'mobile' );
		$areas   = array( 'top', 'right', 'bottom', 'left' );

		$value_bucket = empty( $this->value() ) ? [] : json_decode( $this->value(), true );

		echo '<div class="sf-customize-control sf-responsive-padding-wrap">';

		?>
		<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>

		<ul class="sf-responsive-options">
			<li class="desktop">
				<button type="button" class="preview-desktop active" data-device="desktop">
					<i class="dashicons dashicons-desktop"></i>
				</button>
			</li>
			<li class="tablet">
				<button type="button" class="preview-tablet" data-device="tablet">
					<i class="dashicons dashicons-tablet"></i>
				</button>
			</li>
			<li class="mobile">
				<button type="button" class="preview-mobile" data-device="mobile">
					<i class="dashicons dashicons-smartphone"></i>
				</button>
			</li>
		</ul>

		<?php foreach ( $devices as $device ) { ?>

			<div class="sf-control-device sf-control-<?php echo esc_attr( $device ); ?>">

				<?php foreach ( $areas as $area ) { ?>

					<div class="sf-control-padding-<?php echo esc_attr( $area ); ?>">

						<?php
							$saved_value = isset( $value_bucket[ $device . '_' . $area ] ) ? $value_bucket[ $device . '_' . $area ] : '';
							// Custom sanitization.
							// Only sanitize using intval if we actually have a value
							// Otherwise, default to false. This allows us to save empty fields.
							$saved_value = $saved_value ? intval( $saved_value ) : '';
						?>

						<label>
							<input type="text" value="<?php echo $saved_value; ?>"  class="customize-control-responsive-padding-value" data-area-device-type="<?php echo $device . '_' . $area; ?>">
							<small><?php echo esc_html( ucfirst( $area ) ); ?></small>
						</label>

					</div>

				<?php } ?>

			</div>
			<?php
		}

		printf(
			'<input type="hidden" class="sf-responsive-padding-db" name="%s" value="%s" %s/>',
			esc_attr( $this->id ), esc_attr( $this->value() ), $this->get_link() 
		);

		echo '</div>';

	}

}
