<?php
/**
 * Custom input control.
 *
 * @package Page Builder Framework
 * @subpackage Customizer
 */

defined( 'ABSPATH' ) || exit; // Exit if accessed directly.

class SF_Customize_Control_Responsive_Input extends Kirki\Control\Base {

	public $type = 'sf-responsive-input';

	public function render_content() {
		$devices = array( 'desktop', 'tablet', 'mobile' );
		$value_bucket = empty( $this->value() ) ? [] : json_decode( $this->value(), true );

		?>
		<div class="sf-customize-control sf-responsive-input-wrap">
			<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
			<ul class="sf-responsive-options">
				<li class="desktop">
					<button type="button" class="preview-desktop active" data-device="desktop">
						<i class="dashicons dashicons-desktop"></i>
					</button>
				</li>
				<li class="tablet">
					<button type="button" class="preview-tablet" data-device="tablet">
						<i class="dashicons dashicons-tablet"></i>
					</button>
				</li>
				<li class="mobile">
					<button type="button" class="preview-mobile" data-device="mobile">
						<i class="dashicons dashicons-smartphone"></i>
					</button>
				</li>
			</ul>
			<?php foreach ( $devices as $device ) : $saved_value = isset( $value_bucket[ $device ] ) ? $value_bucket[ $device ] : ''; ?>
				<div class="sf-control-device sf-control-<?php echo esc_attr( $device ); ?>">
					<input type="text" name="<?php echo esc_attr( $this->id ); ?>" value="<?php echo esc_attr( $saved_value ); ?>" class="customize-control-input-value" data-device-type="<?php echo $device; ?>" />
				</div>
				<?php
			endforeach;
			printf(
				'<input type="hidden" class="sf-responsive-input-db" name="%s" value="%s" %s/>',
				esc_attr( $this->id ), esc_attr( $this->value() ), $this->get_link()
			);
		echo '</div>';
	}
}