<?php

/**
 * Custom profile fields
 * @param object $user WP_User
 */
function sf_add_profile_fields ( $user ) {
	?>
	<!-- sf user meta -->
	<h3><?php esc_html_e( 'Social Links', 'spirit' ); ?></h3>
	<table class="form-table">
		<?php foreach ( sf_get_social_icon_names() as $key => $label ) : ?>
		<?php $social_data = get_the_author_meta( 'sf_social_links', $user->ID ); ?>
		<?php $field_id = "sf_$key"; ?>
			<tr>
				<th><label for="<?php echo esc_attr( $field_id ); ?>"><?php echo esc_html( $label ); ?></label></th>
				<td>
					<input type="url" name="<?php echo esc_attr( $field_id ); ?>" id="<?php echo esc_attr( $field_id ); ?>" value="<?php echo ( isset( $social_data[ $key ] ) ? $social_data[ $key ] : '' ); ?>" class="regular-text code">
				</td>
			</tr>
		<?php endforeach; ?>
		<?php do_action( 'sf_edit_user_profile', $user ); ?>
	</table><?php
}

/**
 * Save custom profile fields
 * @param  int $user_id  user ID
 */
function sf_save_user_profile( $user_id ) {
	if ( !current_user_can( 'edit_user', $user_id ) ) {
		return;
	}

	$social_data = array();

	foreach ( sf_get_social_icon_names() as $key => $label ) {
		$field_id = "sf_$key";
		if ( !empty( $_POST[$field_id] ) ) {
			$social_data[ $key ] = $_POST[$field_id];
		}
	}

	if ( !empty( $social_data ) ) {
		update_user_meta( $user_id, 'sf_social_links', $social_data );
	} else {
		delete_user_meta( $user_id, 'sf_social_links' );
	}
		
	do_action( 'sf_save_user_profile', $user_id );
}

add_action( 'show_user_profile', 'sf_add_profile_fields' );
add_action( 'edit_user_profile', 'sf_add_profile_fields' );

add_action( 'personal_options_update', 'sf_save_user_profile' );
add_action( 'edit_user_profile_update', 'sf_save_user_profile' );

add_filter( 'rwmb_meta_boxes', function ( $meta_boxes ) {
	$meta_boxes[] = [
		'title'  => esc_html__( 'Custom Fields', 'spirit' ),
		'type'   => 'user',
		'fields' => [
			[
				'name'             => esc_html__( 'Profile Picture', 'spirit' ),
				'id'               => 'sf_user_avatar',
				'type'             => 'image_advanced',
				'max_file_uploads' => 1,
				'max_status'       => false,
			],
			[
				'name'    => esc_html__( 'Biographical Info', 'spirit' ),
				'id'      => 'sf_user_bio',
				'type'    => 'wysiwyg',
				'raw'     => false,
				'options' => [
					'textarea_rows' => 8,
					'teeny'         => true,
				],
			],
			[
				'name' => esc_html__( 'Job Title', 'spirit' ),
				'id'   => 'sf_user_title',
				'type' => 'text',
				'size' => '40',
			],
		],
	];

	return $meta_boxes;
} );