<?php
$theme_fonts        = SF_Fonts::get_fonts();
$google_web_fonts   = SF_Fonts::get_google_fonts();
$custom_fonts 	    = SF_Fonts::get_custom_fonts();
$adobe_fonts        = SF_Fonts::get_adobe_fonts();
$adobe_fonts_kit_id = SF_Fonts::get_adobe_fonts_kit_id();
?>
<div id="sf-fonts" class="sf-admin-wrap">
	<?php 
	if ( ! empty( $_POST['sf_regenerate_fonts'] ) && check_admin_referer( 'sf_regenerate_fonts' ) ) {
		delete_option( 'kirki_downloaded_font_files' );
		delete_transient( 'kirki_remote_url_contents' );
		?>
		<div class="sf-admin-notice updated-message notice notice-success notice-alt">
			<p><?php esc_html_e( 'Font URLs has been regenerated', 'spirit' ); ?></p>
		</div>
		<?php
	}
	?>
	<div id="sf-font-panel" class="sf-card-alt">
		<h3><?php _e( 'Font List', 'spirit' ); ?></h3>
		<ul id="sf-font-preview">
		<?php if ( ! empty( $theme_fonts ) ) :
				foreach ( $theme_fonts as $key => $font ):
					$font_style = '';
					if ( $font['source'] == 'Custom' ) {
						$font_style = '<style>' . SF_Fonts::get_custom_font_css( $font['family'] ) . '</style>';
					}
				?>
				<li>
					<?php echo $font_style; ?>
					<span class="sf-font-specimen" style="font-family:'<?php echo esc_attr( $font['family'] ); ?>'">Grumpy wizards make toxic brew for the evil Queen and Jack.</span>
					<span class="sf-font-family" data-source="<?php echo esc_attr( $font['source'] ); ?>"><?php echo esc_html( $font['family'] ); ?></span>
					<a href="javascript:void(0)" class="sf-remove-font" title="<?php esc_attr_e( 'Remove Font', 'spirit' ); ?>"><span class="screen-reader-text"><?php _e( 'Remove Font', 'spirit' ); ?></span>X</a>
				</li>
			<?php endforeach; ?>
		<?php endif; ?>
		</ul>
		<ul id="sf-font-details">
		<?php if ( ! empty( $theme_fonts ) ):
				foreach ( $theme_fonts as $font ):
					$variants = SF_Fonts::get_variants( $font['family'] );
					$font_family = ! empty( $font['family'] ) ? $font['family'] : __( 'Unknown', 'spirit' );
					$font_variants = !empty( $font['variants'] ) ? $font['variants'] : '';
					$checked_variants = explode( ',', $font_variants );
					$variant_disabled = count( $variants ) > 1 ? '' : ' disabled';
				?>
				<li>
					<h2 class="sf-font-family" data-font="<?php echo esc_attr( $font_family ); ?>"><?php echo esc_html( $font_family ); ?></h2>
					<div class="sf-font-source"><?php printf( __( 'Source: %s', 'spirit' ), esc_html( $font['source'] ) ); ?></div>
					<?php if ( $font['source'] == 'Google'): ?>
						<div class="sf-font-variant-subset">
							<div class="sf-font-variants">
								<h3><?php _e( 'Variants', 'spirit' ); ?>:</h3>
								<ul class="sf-font-variants-list"><?php foreach( $variants as $variant ):
									$attr = '';
									if ( ! empty( $checked_variants ) && in_array( $variant, $checked_variants ) || !empty( $variant_disabled ) ) {
										$attr = ' checked';
									} ?>
									<li>
										<label>
											<input type="checkbox" data-variant="<?php echo esc_attr( $variant ); ?>" class="sf-check-variant"<?php echo esc_attr( $attr . $variant_disabled ); ?>>
											<?php echo esc_html( $variant ); ?>
										</label>
									</li>
								<?php endforeach; ?>
								</ul>
							</div>
							<div class="clear"></div>
						</div>
					<?php endif; ?>
				</li>
			<?php endforeach; ?>
		<?php endif; ?>
		</ul>
		<div id="sf-save-fonts">
			<a class="sf-save-fonts button-primary" href="javascript:void(0)"><?php _e( 'Save Fonts', 'spirit' ); ?></a>
			<span class="sf-form-messages"></span>
		</div>
	</div>
	<div id="sf-font-library" class="sf-two-columns">
		<div class="sf-column">
			<div id="sf-google-fonts" class="sf-card-alt">
				<h3><?php _e( 'Google Web Fonts', 'spirit' ); ?></h3>
				<div class="sf-card-inner">
					<div id="sf-font-filter">
					<?php $letters = range( 'A', 'Z' );
						foreach ( $letters as $letter ):
							if ( $letter !== 'X' ): ?>
							<a href="javascript:void(0)"><?php echo esc_html( $letter ); ?></a><?php
							endif;
						endforeach; ?>
					</div>
					<ul class="sf-font-list">
					<?php if ( !empty( $google_web_fonts ) ) :
							foreach ( $google_web_fonts as $font ) :
								$font_family = $font['family'];
								$ff = preg_replace( '/\s/', '+', $font_family );
								$preview_link = 'https://www.google.com/fonts/specimen/' . $ff;
							?>
							<li class="sf-fi-<?php echo esc_attr( $font_family[0] ); ?>">
								<span class="sf-font-name"><?php echo esc_html( $font_family ); ?></span>
								<div class="sf-font-actions">
									<a href="<?php echo esc_url( $preview_link ); ?>" target="_blank" class="sf-preview-font"><?php _e( 'Preview', 'spirit' ) ?></a>
									<a href="javascript:void(0)" class="sf-add-font" title="<?php esc_attr_e( 'Add Font', 'spirit' ); ?>" data-source="google">+</a>
								</div>
							</li>
						<?php endforeach; ?>
					<?php endif; ?>
					</ul>
				</div>
			</div>
		</div>
		<div class="sf-column">
			<div id="sf-adobe-fonts" class="sf-card-alt">
				<h3><?php _e( 'Adobe Fonts', 'spirit' ); ?></h3>
				<div class="sf-card-inner">
					<?php if ( ! empty( $adobe_fonts ) ) : ?>
					<ul class="sf-font-list">
						<?php foreach ( $adobe_fonts as $font ) :
								$font_family = $font['name'];
								$preview_link = 'https://fonts.adobe.com/fonts/' . $font['slug'] . '/';
							?>
							<li>
								<span class="sf-font-name"><?php echo esc_html( $font['name'] ); ?></span>
								<div class="sf-font-actions">
									<a href="<?php echo esc_url( $preview_link ); ?>" target="_blank" class="sf-preview-font"><?php _e( 'Preview', 'spirit' ) ?></a>
								</div>
							</li>
						<?php endforeach; ?>
					</ul>
					<?php endif; ?>
					<form id="sf-form-adobe-fonts" method="POST" action="<?php echo esc_url( admin_url( 'admin.php?page=sf_fonts', ( is_ssl() ? 'https' : 'http' ) ) ); ?>" enctype="multipart/form-data">
						<div class="sf-form-messages"></div>
						<div>
							<label for="sf-af-kit-id"><?php echo sprintf( __( 'Enter your <a href="%s" target="_blank" rel="nofollow">Project ID</a>.', 'spirit' ), 'https://fonts.adobe.com/my_fonts#web_projects-section/' ) ?></label>
							<input type="text" name="sf-af-kit-id" id="sf-af-kit-id" value="<?php echo esc_attr( $adobe_fonts_kit_id ); ?>" />
						</div>
						<div>
							<button type="submit" id="sf-af-sync-project" class="button-primary"><?php esc_attr_e( 'Sync Project', 'spirit' ); ?></button>
							<button type="button" id="sf-af-remove-project" class="button" style="display:<?php echo esc_attr( ! empty( $adobe_fonts_kit_id ) ? 'inline' : 'none' ); ?>;"><?php esc_attr_e( 'Remove Project', 'spirit' ); ?></button>
							<?php wp_nonce_field( 'sync_adobe_fonts', 'sync_adobe_fonts_nonce' ); ?>
						</div>
					</form>
				</div>
			</div>
			<div id="sf-custom-fonts" class="sf-card-alt">
				<h3><?php _e( 'Custom Fonts', 'spirit' ); ?></h3>
				<div class="sf-card-inner">
					<ul class="sf-font-list">
					<?php if ( !empty( $custom_fonts ) ) : ?>
						<?php foreach ( $custom_fonts as $font ): ?>
							<li>
								<span class="sf-font-name"><?php echo esc_html( $font['family'] ); ?></span>
								<div class="sf-font-actions">
									<a href="javascript:void(0)" class="sf-add-font" title="<?php esc_attr_e( 'Add Font', 'spirit' ); ?>" data-source="custom">+</a>
									<a href="javascript:void(0)" class="sf-remove-custom-font" title="<?php esc_attr_e( 'Remove Font', 'spirit' ); ?>">&ndash;</a>
								</div>
							</li>
						<?php endforeach; ?>
					<?php endif; ?>
					</ul>
				</div>
			</div>
			<div class="sf-card-alt">
				<h3><?php _e( 'Add Custom Font', 'spirit' ); ?></h3>
				<div class="sf-card-inner">
					<form id="sf-form-custom-font" method="POST" action="<?php echo esc_url( admin_url( 'admin.php?page=sf_fonts', ( is_ssl() ? 'https' : 'http' ) ) ); ?>" enctype="multipart/form-data">
						<div class="sf-form-messages"></div>
						<div>
							<label for="sf-file-woff"><?php _e( 'Custom Fonts', 'spirit' ); ?>.woff</label>
							<div class="sf-file-input">
								<span class="sf-file-name"></span>
								<div class="sf-upload-buttons">
									<input type="file" name="sf-ff-woff" id="sf-ff-woff" class="sf-ff">
									<input type="button" class="sf-upload-submit" value="<?php esc_attr_e( 'Upload', 'spirit' ); ?>">
									<input type="button" class="sf-upload-remove" value="X">
								</div>
							</div>
						</div>
						<div>
							<label for="sf-file-woff2"><?php _e( 'Custom Fonts', 'spirit' ); ?>.woff2</label>
							<div class="sf-file-input">
								<span class="sf-file-name"></span>
								<div class="sf-upload-buttons">
									<input type="file" name="sf-ff-woff2" id="sf-ff-woff2" class="sf-ff">
									<input type="button" class="sf-upload-submit" value="<?php esc_attr_e( 'Upload', 'spirit' ); ?>">
									<input type="button" class="sf-upload-remove" value="X">
								</div>
							</div>
						</div>
						<div>
							<label for="sf-file-ttf"><?php _e( 'Custom Fonts', 'spirit' ); ?>.ttf</label>
							<div class="sf-file-input">
								<span class="sf-file-name"></span>
								<div class="sf-upload-buttons">
									<input type="file" name="sf-ff-ttf" id="sf-ff-ttf" class="sf-ff">
									<input type="button" class="sf-upload-submit" value="<?php esc_attr_e( 'Upload', 'spirit' ); ?>">
									<input type="button" class="sf-upload-remove" value="X">
								</div>
							</div>
						</div>
						<div>
							<label for="sf-file-svg"><?php _e( 'Custom Fonts', 'spirit' ); ?>.svg</label>
							<div class="sf-file-input">
								<span class="sf-file-name"></span>
								<div class="sf-upload-buttons">
									<input type="file" name="sf-ff-svg" id="sf-ff-svg" class="sf-ff">
									<input type="button" class="sf-upload-submit" value="<?php esc_attr_e( 'Upload', 'spirit' ); ?>">
									<input type="button" class="sf-upload-remove" value="X">
								</div>
							</div>
						</div>
						<div>
							<label for="sf-file-eot"><?php _e( 'Custom Fonts', 'spirit' ); ?>.eot</label>
							<div class="sf-file-input">
								<span class="sf-file-name"></span>
								<div class="sf-upload-buttons">
									<input type="file" name="sf-ff-eot" id="sf-ff-eot" class="sf-ff">
									<input type="button" class="sf-upload-submit" value="<?php esc_attr_e( 'Upload', 'spirit' ); ?>">
									<input type="button" class="sf-upload-remove" value="X">
								</div>
							</div>
						</div>
						<div>
							<label for="sf-custom-font-name"><?php _e( 'Font Name', 'spirit' ); ?></label>
							<input type="text" name="sf-custom-font-name" id="sf-custom-font-name">
						</div>
						<div>
							<button type="submit" class="sf-add-custom-font button-primary"><?php esc_html_e( 'Add Custom Font', 'spirit' ); ?></button>
							<?php wp_nonce_field( 'add_custom_font', 'custom_font_nonce' ); ?>
						</div>
					</form>
				</div>
			</div>
			<div class="sf-card-alt">
				<h3><?php esc_html_e( 'Tools', 'spirit' ); ?></h3>
				<div class="sf-card-inner">
					<p><?php esc_html_e( 'If you experience issues with font loading in the frontend after site migration, please try to regenerate font URLs.', 'spirit' ); ?></p>
					<form action="" method="POST" action="<?php echo esc_url( admin_url( 'admin.php?page=sf_fonts', ( is_ssl() ? 'https' : 'http' ) ) ); ?>">
						<input type="hidden" name="sf_regenerate_fonts" value="1">
						<?php wp_nonce_field( 'sf_regenerate_fonts' ); ?>
						<button type="submit" class="button button-primary button-large"><?php esc_html_e( 'Regenerate Fonts URLs', 'spirit' ); ?></button>
					</form>
				</div>
			</div>
		</div>
	</div>
	<div class="clear"></div>
</div>