<?php
$demos = apply_filters( 'sf_config_demos', array() );
$demo_pages = apply_filters( 'sf_config_demo_pages', array() );
$demo_data = get_option( 'sf_demo_data' );
$demo_data = !empty( $demo_data ) ? $demo_data : array();
$demo_history = get_option( 'sf_demo_history' );
$current_demo_id = get_option( 'sf_demo_current' );
$current_demo_id = !empty( $current_demo_id ) ? $current_demo_id : '';
$content_type_labels = array(
	'all' => __( 'All', 'spirit' ),
	'images' => __( 'Images', 'spirit' ),
	'pages' => __( 'Pages', 'spirit' ),
	'posts' => __( 'Posts', 'spirit' ),
	'portfolio' => __( 'Portfolio', 'spirit' ),
	'products' => __( 'Products', 'spirit' ),
	'widgets' => __( 'Widgets', 'spirit' ),
	'options' => __( 'Theme Options', 'spirit' ),
	'sliders' => __( 'Sliders', 'spirit' ),
	'courses' => __( 'Courses', 'spirit' ),
	'events' => __( 'Events', 'spirit' ),
	'menus' => __( 'Menus', 'spirit' )
);
?>
<div id="sf-demos" class="sf-admin-wrap">
	<div class="sf-three-columns sf-md-gutter">
	<?php foreach ( $demos as $demo ) :
		$demo_id = isset( $demo['id'] ) ? $demo['id'] : '';
		$demo_label = isset( $demo['label'] ) ? $demo['label'] : '';
		$demo_thumbnail = isset( $demo['thumbnail'] ) ? $demo['thumbnail'] : '';
		$demo_preview = isset( $demo['preview'] ) ? $demo['preview'] : '';
		$demo_content = isset( $demo['content'] ) ? $demo['content'] : array();
		$demo_plugins = isset( $demo['plugin_dep'] ) ? $demo['plugin_dep'] : array();
		?>
		<div class="sf-demo-item<?php echo ( $current_demo_id == $demo_id ) ? ' sf-demo-installed' : ''; ?>">
			<div class="sf-demo-item-inner">
				<div class="sf-demo-item-overlay"></div>
				<div class="sf-demo-item-screenshot">
					<a href="javascript:void(0)" data-toggle="modal" data-target="#sf-demo-modal-<?php echo esc_attr( $demo_id ); ?>" data-backdrop="false">
						<img src="<?php echo esc_url( $demo_thumbnail ); ?>" alt="<?php echo esc_attr( $demo_label ); ?>">
					</a>
				</div>
				<div class="sf-demo-item-bar">
					<div class="sf-demo-item-title"><?php echo esc_html( $demo_label ); ?></div>
					<div class="sf-demo-item-buttons">
						<input type="submit" class="button button-primary sf-button-uninstall" value="<?php esc_attr_e( 'Uninstall', 'spirit' ); ?>" data-toggle="modal" data-target="#sf-demo-modal-<?php echo esc_attr( $demo_id ); ?>"  data-backdrop="false">
						<input type="submit" class="button button-primary sf-button-install" value="<?php esc_attr_e( 'Install', 'spirit' ); ?>" data-toggle="modal" data-target="#sf-demo-modal-<?php echo esc_attr( $demo_id ); ?>"  data-backdrop="false">
						<a class="button button-secondary sf-button-preview" href="<?php echo esc_url( $demo_preview ); ?>" target="_blank"><?php esc_html_e( 'Preview', 'spirit' ); ?></a>
					</div>
				</div>
			    <div class="modal sf-modal sf-demo-modal" id="sf-demo-modal-<?php echo esc_attr( $demo_id ); ?>" tabindex="-1" role="dialog" aria-labelledby="<?php esc_attr_e( 'Demo Modal', 'spirit' ); ?>">
			        <div class="modal-dialog modal-dialog-centered" role="document">
			        	<form class="sf-demo-form" data-demo-id="<?php echo esc_attr( $demo_id ); ?>" action="" autocomplete="off">
				            <div class="modal-content">
				                <div class="modal-header">
				                    <h2><?php esc_html_e( 'Import Demo', 'spirit' ); ?></h2>
				                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
				                </div>
				                <div class="modal-body">
									<div class="sf-demo-options sf-demo-general">
										<?php
											$checkbox_id = 'import-all-'. $demo_id;
											$all_attr    = $current_demo_id == $demo_id && !empty( $demo_data['all'] ) ? ' checked="checked" disabled' : ' checked="checked"';
										?>
										<label for="<?php echo esc_attr( $checkbox_id ); ?>">
											<input type="checkbox" name="all" id="<?php echo esc_attr( $checkbox_id ); ?>" class="sf-demo-form-input-checkbox" value="all"<?php echo $all_attr; // WPCS: XSS ok. ?>><?php echo esc_html( $content_type_labels['all'] ); ?>
										</label>
										<?php
											foreach ( $demo_content as $content_type ) :
												$checkbox_id   = 'import-'. $content_type .'-'. $demo_id;
												$attr_checked  = empty( $current_demo_id ) || $current_demo_id != $demo_id || ( $current_demo_id == $demo_id && !empty( $demo_data[ $content_type ] ) ) ? ' checked="checked"' : '';
												$attr_disabled = $current_demo_id == $demo_id && !empty( $demo_data[ $content_type ] ) ? ' disabled' : '';
											?>
											<label for="<?php echo esc_attr( $checkbox_id ); ?>">
												<input type="checkbox" name="<?php echo esc_attr( $content_type ); ?>" id="<?php echo esc_attr( $checkbox_id ); ?>" class="sf-demo-form-input-checkbox" value="<?php echo esc_attr( $content_type ); ?>"<?php echo $attr_checked . $attr_disabled; // WPCS: XSS ok. ?>>
												<span class="sf-demo-form-input-label"><?php echo esc_html( $content_type_labels[ $content_type ] ); ?></span>
											</label>
										<?php endforeach; ?>
									</div>
									<div class="sf-demo-options sf-demo-pages">
										<button type="button" class="button button-secondary small sf-demo-pages-toggle"><?php esc_html_e( 'Select Pages', 'spirit' ); ?></button>
										<ul class="sf-demo-page-list">
										<?php
											foreach( $demo_pages as $item_key => $item_label ) :
												$attr_checked  = empty( $current_demo_id ) || $current_demo_id != $demo_id || ( $current_demo_id == $demo_id && !empty( $demo_data[ $item_key ] ) ) ? ' checked="checked"' : '';
												$attr_disabled = $current_demo_id == $demo_id && !empty( $demo_data[ $item_key ] ) ? ' disabled' : '';
											?>
											<li>
												<label>
													<input type="checkbox" name="pages" value="<?php echo esc_attr( $item_key ); ?>" class="sf-demo-form-input-checkbox"<?php echo $attr_checked . $attr_disabled; // WPCS: XSS ok. ?>>
													<span class="sf-demo-form-input-label"><?php echo esc_html( $item_label ); ?></span>
												</label>
											</li>
										<?php endforeach; ?>
										</ul>
									</div>
				                </div>
				                <div class="modal-footer">
									<div class="sf-demo-status sf-label-installed"><span class="dashicons dashicons-smiley"></span></div>
									<div class="sf-demo-status sf-label-installing"><span class="sf-demo-status-text"></span></div>
				                	<div class="sf-progress-bar"></div>
				                	<input type="submit" class="button button-large button-primary sf-demo-install" value="<?php esc_attr_e( 'Install', 'spirit' ); ?>" data-demo-id="<?php echo esc_attr( $demo_id ); ?>"<?php if ( !empty( $all_attr_disabled ) ) echo ' style="display:none;"'; ?>>
				                	<input type="submit" class="button button-large button-primary sf-demo-uninstall" value="<?php esc_attr_e( 'Uninstall', 'spirit' ); ?>">
				                </div>
				            </div>
				        </div>
			        </form>
			    </div>
			</div>
		</div>
	<?php endforeach; ?>
	</div>
</div>