<?php
$theme_config      = apply_filters( 'sf_config_theme', [] );
$theme_data        = SF_Theme_Manager::get_theme();
$remote_theme_data = SF_Theme_Manager::get_remote_theme_data();
$remote_version    = isset( $remote_theme_data['version'] ) ? $remote_theme_data['version'] : '1';
$can_upgrade       = version_compare( $remote_version, $theme_data['version'], '>' );
$last_update_check = false;
?>
<div id="sf-dashboard" class="sf-admin-wrap">
	<div class="sf-two-columns">
		<div class="sf-column">
			<div class="sf-card-alt">
				<h3><?php esc_html_e( 'Theme', 'spirit' ); ?></h3>	
				<div class="sf-card-inner">
					<div class="sf-theme-info">
						<a href="<?php echo esc_url( $remote_theme_data['product_url'] ); ?>" class="sf-theme-thumbnail">
							<?php if ( ! empty( $remote_theme_data['thumbnail_url'] ) ) : ?>
							<img src="<?php echo esc_url( $remote_theme_data['thumbnail_url'] ); ?>" alt="theme thumbnail">	
							<?php endif; ?>
						</a>
						<div class="sf-theme-details">
							<h4 class="sf-theme-name">
								<?php echo esc_html( $theme_data['name'] ); ?>
								<span class="sf-theme-version"><?php echo sprintf( __( 'Version %s', 'spirit' ), $theme_data['version'] ); ?></span>
							</h4>
							<div class="sf-theme-author"><?php printf( __( 'By <a href="%1$s" target="_blank">%2$s</a>', 'spirit' ), $theme_data['author_uri'], $theme_data['author'] ); ?></div>
						</div>
					</div>
					<?php if ( current_user_can( 'update_themes' ) ) : ?>
						<?php if ( $can_upgrade ) : ?>
							<div class="sf-admin-notice update-message notice inline notice-warning notice-alt"><p>
								<?php if ( sf_product_registration()->is_registered() ) : ?>
									<?php esc_html_e( 'New version available.', 'spirit' ); ?> <button id="sf-update-theme" class="button-link" type="button" data-slug="<?php echo esc_attr( $theme_data['slug'] ); ?>" data-action="update" data-nonce="<?php echo wp_create_nonce( 'sf_theme_manager' ); ?>"><?php esc_html_e( 'Update now', 'spirit' ); ?></button>
								<?php else : ?>
									<?php esc_html_e( 'New version available. Complete theme registration to update the theme.' ); ?>
								<?php endif; ?>
								</p>
							</div>
						<?php endif; ?>
						<?php $current = get_site_transient( 'update_core' );
						if ( $current && isset( $current->last_checked ) ) {
							$last_update_check = $current->last_checked + get_option( 'gmt_offset' ) * HOUR_IN_SECONDS;
						} ?>
						<div class="sf-last-checked">
							<?php printf( __( 'Last checked on %1$s at %2$s.' ), date_i18n( __( 'F j, Y' ), $last_update_check ), date_i18n( __( 'g:i a T' ), $last_update_check ) ); echo ' <a href="' . esc_url( self_admin_url( 'admin.php?page=sf_dashboard&force-check=1' ) ) . '">' . __( 'Check again.' ) . '</a>'; ?>
						</div>
					<?php endif; ?>
				</div>
			</div>
			<div class="sf-card-alt sf-product-registration" id="sf-product-registration">
				<h3><?php esc_html_e( 'Theme Registration', 'spirit' ); ?></h3>
				<div class="sf-card-inner">
					<?php sf_product_registration()->form(); ?>
				</div>
			</div>
			<?php if ( SF_Theme_Manager::get_child_theme() == false ) : ?>
			<div class="sf-card-alt">
				<h3><?php esc_html_e( 'Child Theme', 'spirit' ); ?></h3>
				<div class="sf-card-inner">
					<p><?php esc_html_e( 'Child theme inherits the style, functionality and features of the parent theme. It\'s recommended to make customize changes to the child theme instead of the parent theme.', 'spirit' ); ?></p>
					<button id="sf-install-child" class="button button-primary button-large sf-update-theme" data-action="install-child" data-slug="<?php echo esc_attr( $theme_data['slug'] ); ?>" data-nonce="<?php echo wp_create_nonce( 'sf_theme_manager' ); ?>"><?php esc_html_e( 'Install Child Theme', 'spirit' ); ?></button>
				</div>
			</div>
			<?php endif; ?>
		</div>
		<div class="sf-column">
			<div class="sf-card-alt">
				<h3><?php esc_html_e( 'Appearance', 'spirit' ); ?></h3>
				<div class="sf-card-inner">
					<div class="sf-icon-box-wrapper">
						<a class="sf-icon-box" href="<?php echo wp_customize_url(); ?>">
							<span class="dashicons dashicons-admin-customizer"></span>
							<h4 class="sf-icon-box-title"><?php esc_html_e( 'Customize', 'spirit' ); ?></h4>
						</a>
						<a class="sf-icon-box" href="<?php echo admin_url( 'nav-menus.php' ); ?>">
							<span class="dashicons dashicons-menu"></span>
							<h4 class="sf-icon-box-title"><?php esc_html_e( 'Menus', 'spirit' ); ?></h4>
						</a>
						<a class="sf-icon-box" href="<?php echo admin_url( 'nav-menus.php' ); ?>">
							<span class="dashicons dashicons-admin-tools"></span>
							<h4 class="sf-icon-box-title"><?php esc_html_e( 'Widgets', 'spirit' ); ?></h4>
						</a>
					</div>
				</div>
			</div>
			<div class="sf-card-alt sf-theme-support">
				<h3><?php esc_html_e( 'Theme Support', 'spirit' ); ?></h3>
				<div class="sf-card-inner">
					<?php if ( ! empty( $theme_config['doc_url'] ) ) : ?>
						<div class="sf-card-row">
							<h3><span class="dashicons dashicons-book"></span><?php esc_html_e( 'Documentation', 'spirit' ); ?></h3>
							<p><?php esc_html_e( 'Want step by step how to guides? Our online documentation is the great place to start learning all the in and outs of the theme.', 'spirit' ); ?></p>
							<a class="button button-primary button-large" href="<?php echo esc_url( $theme_config['doc_url'] ); ?>" target="_blank"><?php esc_html_e( 'Documentation', 'spirit' ); ?></a>
						</div>
					<?php endif; ?>
					<?php if ( ! empty( $theme_config['video_url'] ) ) : ?>
						<div class="sf-card-row">
							<h3><span class="dashicons dashicons-format-video"></span><?php esc_html_e( 'Video Tutorials', 'spirit' ); ?></h3>
							<p><?php esc_html_e( 'Nothing is better than watching a video to learn. We have a growing number of high-definititon video tutorials to help you know the different aspects of the theme.', 'spirit' ); ?></p>
							<a class="button button-primary button-large" href="<?php echo esc_url( $theme_config['video_url'] ); ?>" target="_blank"><?php esc_html_e( 'Watch Videos', 'spirit' ); ?></a>
						</div>
					<?php endif; ?>
					<div class="sf-card-row">
						<h3><span class="dashicons dashicons-sos"></span><?php esc_html_e( 'Submit A Ticket', 'spirit' ); ?></h3>
						<p><?php esc_html_e( 'We offer outstanding support through our support center. To submit a ticket first you need to register an account and verify your purchase.', 'spirit' ); ?></p>
						<div class="right-align">
							<a class="button button-primary button-large" href="https://themespirit.com/support" target="_blank"><?php esc_html_e( 'Support Center', 'spirit' ); ?></a>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>