<?php

add_filter( 'mb_settings_pages', function ( $settings_pages ) {

	$settings_pages[] = [
		'id'          => 'sf_settings',
		'option_name' => 'sf_settings',
		'menu_title'  => esc_html__( 'Settings', 'spirit' ),
		'parent'      => 'sf_dashboard',
		'icon_url'    => 'dashicons-edit',
		'class'       => 'sf-settings-page',
		'style'       => 'no-boxes',
		'columns'     => 1,
		'position'    => 2,
		'tabs'        => [
			'main'        => esc_html__( 'General', 'spirit' ),
			'forms'       => esc_html__( 'Forms', 'spirit' ),
			'emails'      => esc_html__( 'Emails', 'spirit' ),
			'integration' => esc_html__( 'Integration', 'spirit' ),
		],
	];

	return $settings_pages;

} );

// Register meta boxes and fields for settings page
add_filter( 'rwmb_meta_boxes', function ( $meta_boxes ) {
	$default_settings = SF()->get_default_settings();

	$meta_boxes[] = [
		'id'             => 'main',
		'title'          => esc_html__( 'General', 'spirit' ),
		'settings_pages' => 'sf_settings',
		'tab'            => 'main',
		'fields'         => [
			[
				'type' => 'heading',
				'name' => esc_html__( 'Modules' ),
			],
			[
				'id'   => 'enable_custom_sidebars',
				'name' => esc_html__( 'Custom Sidebars', 'spirit' ),
				'desc' => esc_html__( 'Enable Custom Sidebars', 'spirit' ),
				'type' => 'checkbox',
				'std'  => $default_settings['enable_custom_sidebars'],
			],
			[
				'id'   => 'enable_login_registration',
				'name' => esc_html__( 'Login & Registration', 'spirit' ),
				'desc' => esc_html__( 'Enable User Login & Registration', 'spirit' ),
				'type' => 'checkbox',
				'std'  => $default_settings['enable_login_registration'],
			],
			[
				'id'   => 'disable_login_modal',
				'name' => esc_html__( 'Disable Login Modal', 'spirit' ),
				'desc' => esc_html__( 'Checking this option will prevent login modal and scripts from printing on every page', 'spirit' ),
				'type' => 'checkbox',
				'std'  => $default_settings['disable_login_modal'],
			],
			[
				'id'   => 'disable_fa5',
				'name' => esc_html__( 'Disable Font Awesome 5', 'spirit' ),
				'desc' => esc_html__( 'Checking this option will prevent loading Font Awesome 5 Assets in the frontend', 'spirit' ),
				'type' => 'checkbox',
				'std'  => $default_settings['disable_fa5'],
			],
		],
	];

	$meta_boxes[] = [
		'id'             => 'forms',
		'title'          => esc_html__( 'Forms', 'spirit' ),
		'settings_pages' => 'sf_settings',
		'tab'            => 'forms',
		'fields'         => [
			[
				'type' => 'heading',
				'name' => esc_html__( 'General' ),
			],
			[
				'id'        => 'login_redirect_page',
				'name'      => esc_html__( 'Login Redirect Page', 'spirit' ),
				'type'      => 'post',
				'post_type' => 'page',
			],
			[
				'id'        => 'registration_redirect_page',
				'name'      => esc_html__( 'Registeration Redirect Page', 'spirit' ),
				'type'      => 'post',
				'post_type' => 'page',
			],
			[
				'id'        => 'verification_page',
				'name'      => esc_html__( 'Verification Page', 'spirit' ),
				'type'      => 'post',
				'post_type' => 'page',
			],
			[
				'id'        => 'verification_redirect_page',
				'name'      => esc_html__( 'Verification Redirect Page', 'spirit' ),
				'type'      => 'post',
				'post_type' => 'page',
			],
			[
				'id'        => 'reset_password_page',
				'name'      => esc_html__( 'Reset Password Page', 'spirit' ),
				'type'      => 'post',
				'post_type' => 'page',
			],
			[
				'id'   => 'new_account_verify_email',
				'name' => esc_html__( 'Email Verification', 'spirit' ),
				'desc' => esc_html__( 'New account requires email verification', 'spirit' ),
				'type' => 'checkbox',
			],
			[
				'id'   => 'verification_auto_login',
				'name' => esc_html__( 'Verification Auto login', 'spirit' ),
				'desc' => esc_html__( 'Automatically login after verification', 'spirit' ),
				'type' => 'checkbox',
			],
			[
				'id'   => 'password_strength_meter',
				'name' => esc_html__( 'Password Strength Meter', 'spirit' ),
				'desc' => esc_html__( 'Enable Password Strength Meter', 'spirit' ),
				'type' => 'checkbox',
				'std'  => 1,
			],
			[
				'type' => 'heading',
				'name' => esc_html__( 'Login', 'spirit' ),
			],
			[
				'id'   => 'login_remember_me',
				'name' => esc_html__( 'Remember Me', 'spirit' ),
				'desc' => esc_html__( 'Display remember me field in Login Form', 'spirit' ),
				'type' => 'checkbox',
			],
			[
				'type' => 'heading',
				'name' => esc_html__( 'Registration', 'spirit' ),
			],
			[
				'id'       => 'new_account_default_roles',
				'name'     => esc_html__( 'New User Default Roles', 'spirit' ),
				'type'     => 'select_advanced',
				'multiple' => 1,
				'options'  => sf_get_option_user_roles(),
			],
			[
				'id'   => 'new_account_generate_username',
				'name' => esc_html__( 'Autogenerate Username', 'spirit' ),
				'desc' => esc_html__( 'When creating an account, automatically generate a username from the user\'s email address', 'spirit' ),
				'type' => 'checkbox',
			],
			[
				'id'   => 'new_account_generate_password',
				'name' => esc_html__( 'Autogenerate Password', 'spirit' ),
				'desc' => esc_html__( 'When creating an account, automatically generate an account password', 'spirit' ),
				'type' => 'checkbox',
			],
			[
				'id'   => 'new_account_first_last_name',
				'name' => esc_html__( 'First name and Last name', 'spirit' ),
				'desc' => esc_html__( 'Display first name and last name fields in Registration Form', 'spirit' ),
				'type' => 'checkbox',
			],
			[
				'id'   => 'new_account_agreement_text',
				'name' => esc_html__( 'New Account Agreement', 'spirit' ),
				'desc' => esc_html__( 'Optionally add some text about your site terms and privacy policy to show on account registration form.', 'spirit' ),
				'type' => 'textarea',
				'std'  => $default_settings['new_account_agreement_text'],
			],
			[
				'id'        => 'terms_page_id',
				'name'      => esc_html__( 'Terms and Conditions Page', 'spirit' ),
				'type'      => 'post',
				'post_type' => 'page',
			],
			[
				'id'        => 'privacy_page_id',
				'name'      => esc_html__( 'Privacy Policy Page', 'spirit' ),
				'type'      => 'post',
				'post_type' => 'page',
			],
			[
				'type' => 'heading',
				'name' => esc_html__( 'Custom Registration Fields', 'spirit' ),
			],
			[
				'id'         => 'new_account_fields',
				'type'       => 'group',
				'clone'      => true,
				'sort_clone' => true,
				'fields'     => [
					[
						'name'    => esc_html__( 'Field Type', 'spirit' ),
						'id'      => 'type',
						'type'    => 'select',
						'options' => [
							'text'   => esc_html__( 'Text', 'spirit' ),
							'email'  => esc_html__( 'Email', 'spirit' ),
							'tel'    => esc_html__( 'Phone', 'spirit' ),
							'number' => esc_html__( 'Number', 'spirit' ),
							'date'   => esc_html__( 'Date', 'spirit' ),
							'url'    => esc_html__( 'URL', 'spirit' ),
						],
					],
					[
						'name' => esc_html__( 'Label', 'spirit' ),
						'id'   => 'label',
					],
					[
						'name' => esc_html__( 'Icon', 'spirit' ),
						'id'   => 'icon',
						'type' => 'text',
						'placeholder' => 'e.g. fas fa-user',
						'desc' => '<a href="https://fontawesome.com/v5/search" target="_blank">' . esc_html__( 'Font Awesome Icons', 'spirit' ) . '</a>'
					],
					[
						'name' => esc_html__( 'ID', 'spirit' ),
						'id'   => 'id',
						'type' => 'text',
						'desc' => esc_html__( 'Unique ID, only accept alphanumeric and _ characters without space. It will be used as meta_key in usermeta table.', 'spirit' ),
					],
					[
						'name' => esc_html__( 'Required', 'spirit' ),
						'id'   => 'required',
						'type' => 'checkbox',
						'desc' => esc_html__( 'Check this option to mark the field required', 'spirit' ),
					],
				],
			],
		],
	];

	$meta_boxes[] = [
		'id'             => 'emails',
		'title'          => esc_html__( 'Emails', 'spirit' ),
		'settings_pages' => 'sf_settings',
		'tab'            => 'emails',
		'fields'         => [
			[
				'type' => 'heading',
				'name' => esc_html__( 'General' ),
			],
			[
				'id'   => 'email_logo',
				'name' => esc_html__( 'Logo', 'spirit' ),
				'type' => 'file_input',
				'desc' => esc_html__( 'URL to an image you want to show in the email header. Displayed on HTML emails only.', 'spirit' ),
			],
			[
				'id'   => 'from_name',
				'name' => esc_html__( 'From Name', 'spirit' ),
				'type' => 'text',
				'std'  => $default_settings['from_name'],
				'desc' => esc_html__( 'How the sender name appears in outgoing emails.', 'spirit' ),
			],
			[
				'id'   => 'from_email',
				'name' => esc_html__( 'From Email', 'spirit' ),
				'desc' => esc_html__( 'How the sender email appears in outgoing emails.', 'spirit' ),
				'type' => 'email',
				'std'  => $default_settings['from_email'],
			],
			[
				'id'      => 'email_type',
				'name'    => esc_html__( 'Email Type', 'spirit' ),
				'type'    => 'select',
				'options' => [
					'plain'     => esc_html__( 'Plain text', 'spirit' ),
					'html'      => esc_html__( 'HTML', 'spirit' ),
					'multipart' => esc_html__( 'Multipart', 'spirit' ),
				],
				'std'     => $default_settings['email_type'],
				'desc'    => esc_html__( 'Choose which format of email to send.', 'spirit' ),
			],
			[
				'id'      => 'email_content',
				'name'    => esc_html__( 'Email Content', 'spirit' ),
				'type'    => 'select',
				'options' => [
					'template' => esc_html__( 'Template', 'spirit' ),
					'option'   => esc_html__( 'Option', 'spirit' ),
				],
				'std'     => $default_settings['email_content'],
				'desc'    => esc_html__( 'Choose which email content to use', 'spirit' ),
			],
			[
				'type' => 'heading',
				'name' => esc_html__( 'New Account' ),
			],
			[
				'id'          => 'new_account_subject',
				'name'        => esc_html__( 'Email Subject', 'spirit' ),
				'type'        => 'text',
				'size'        => 60,
				'placeholder' => esc_html__( 'Your account on {site_title}', 'spirit' ),
			],
			[
				'id'          => 'new_account_heading',
				'name'        => esc_html__( 'Email Heading', 'spirit' ),
				'type'        => 'text',
				'size'        => 60,
				'placeholder' => esc_html__( 'Welcome to {site_title}', 'spirit' ),
			],
			[
				'id'      => 'new_account_email_content',
				'name'    => esc_html__( 'Email Content', 'spirit' ),
				'type'    => 'wysiwyg',
				'std'     => $default_settings['new_account_email_content'],
				'desc'    => sprintf( __( '%s - Site Title' ), '{site_title}' ) . '<br />' . sprintf( __( '%s - User login' ), '{username}' ) . '<br />' . sprintf( __( '%s - User password' ), '{password}' ),
				'options' => [
					'textarea_rows' => 15,
				],
				'visible' => ['email_content', '=', 'option'],
			],
			[
				'id'      => 'plain_template',
				'name'    => esc_html__( 'Plain template', 'spirit' ),
				'type'    => 'custom_html',
				'desc'    => esc_html__( 'To override and edit this email template copy <code>spirit-framework/templates/emails/plain/new-account.php</code> to your theme folder: <code>yourtheme/spirit/emails/plain/new-account.php</code>', 'spirit' ),
				'visible' => ['email_content', '=', 'template'],
			],
			[
				'id'      => 'html_template',
				'name'    => esc_html__( 'HTML template', 'spirit' ),
				'type'    => 'custom_html',
				'desc'    => esc_html__( 'To override and edit this email template copy <code>spirit-framework/templates/emails/new-account.php</code> to your theme folder: <code>yourtheme/spirit/emails/new-account.php</code>', 'spirit' ),
				'visible' => ['email_content', '=', 'template'],
			],
			[
				'type' => 'heading',
				'name' => esc_html__( 'Reset Password' ),
			],
			[
				'id'          => 'reset_password_subject',
				'name'        => esc_html__( 'Email Subject', 'spirit' ),
				'type'        => 'text',
				'size'        => 60,
				'placeholder' => esc_html__( 'Password reset for {site_title}', 'spirit' ),
			],
			[
				'id'          => 'reset_password_heading',
				'name'        => esc_html__( 'Email Heading', 'spirit' ),
				'type'        => 'text',
				'size'        => 60,
				'placeholder' => esc_html__( 'Password reset instructions', 'spirit' ),
			],
			[
				'id'      => 'reset_password_email_content',
				'name'    => esc_html__( 'Email Content', 'spirit' ),
				'type'    => 'wysiwyg',
				'std'     => $default_settings['reset_password_email_content'],
				'desc'    => sprintf( __( '%s - Site Title' ), '{site_title}' ) . '<br />' . sprintf( __( '%s - User login' ), '{username}' ) . '<br />' . sprintf( __( '%s - Reset password link' ), '{reset_password_url}' ),
				'options' => [
					'textarea_rows' => 15,
				],
				'visible' => ['email_content', '=', 'option'],
			],
			[
				'id'      => 'plain_template',
				'name'    => esc_html__( 'Plain template', 'spirit' ),
				'type'    => 'custom_html',
				'desc'    => esc_html__( 'To override and edit this email template copy <code>spirit-framework/templates/emails/plain/reset-password.php</code> to your theme folder: <code>yourtheme/spirit/emails/plain/reset-password.php</code>', 'spirit' ),
				'visible' => ['email_content', '=', 'template'],
			],
			[
				'id'      => 'html_template',
				'name'    => esc_html__( 'HTML template', 'spirit' ),
				'type'    => 'custom_html',
				'desc'    => esc_html__( 'To override and edit this email template copy <code>spirit-framework/templates/emails/reset-password.php</code> to your theme folder: <code>yourtheme/spirit/emails/reset-password.php</code>', 'spirit' ),
				'visible' => ['email_content', '=', 'template'],
			],
			[
				'type' => 'heading',
				'name' => esc_html__( 'Account Confirmation' ),
			],
			[
				'id'          => 'activate_account_subject',
				'name'        => esc_html__( 'Email Subject', 'spirit' ),
				'type'        => 'text',
				'size'        => 60,
				'placeholder' => esc_html__( 'Account Confirmation', 'spirit' ),
			],
			[
				'id'          => 'activate_account_heading',
				'name'        => esc_html__( 'Email Heading', 'spirit' ),
				'type'        => 'text',
				'size'        => 60,
				'placeholder' => esc_html__( 'Account Confirmation', 'spirit' ),
			],
			[
				'id'      => 'activate_account_email_content',
				'name'    => esc_html__( 'Email Content', 'spirit' ),
				'type'    => 'wysiwyg',
				'std'     => $default_settings['activate_account_email_content'],
				'desc'    => sprintf( __( '%s - Site Title' ), '{site_title}' ) . '<br />' . sprintf( __( '%s - User login' ), '{username}' ) . '<br />' . sprintf( __( '%s - User Password' ), '{password}' ) . '<br />' . sprintf( __( '%s - Email confirmation link' ), '{email_confirmation_link}' ),
				'options' => [
					'textarea_rows' => 15,
				],
				'visible' => ['email_content', '=', 'option'],
			],
			[
				'id'      => 'plain_template',
				'name'    => esc_html__( 'Plain template', 'spirit' ),
				'type'    => 'custom_html',
				'desc'    => esc_html__( 'To override and edit this email template copy <code>spirit-framework/templates/emails/plain/activate-account.php</code> to your theme folder: <code>yourtheme/spirit/emails/plain/activate-account.php</code>', 'spirit' ),
				'visible' => ['email_content', '=', 'template'],
			],
			[
				'id'      => 'html_template',
				'name'    => esc_html__( 'HTML template', 'spirit' ),
				'type'    => 'custom_html',
				'desc'    => '<p>' . __( 'To override and edit this email template copy <code>spirit-framework/templates/emails/activate-account.php</code> to your theme folder: <code>yourtheme/spirit/emails/activate-account.php</code>', 'spirit' ) . '</p>',
				'visible' => ['email_content', '=', 'template'],
			],
		],
	];

	$meta_boxes[] = [
		'id'             => 'integration',
		'title'          => esc_html__( 'Integration', 'spirit' ),
		'settings_pages' => 'sf_settings',
		'tab'            => 'integration',
		'fields'         => [
			[
				'type' => 'heading',
				'name' => esc_html__( 'reCaptcha' ),
				'desc' => esc_html__( 'reCAPTCHA protects you against spam and other types of automated abuse.', 'spirit' ),
			],
			[
				'type' => 'checkbox',
				'name' => esc_html__( 'Enable Google reCaptcha', 'spirit' ),
				'id'   => 'recaptcha',
			],
			[
				'type' => 'text',
				'name' => esc_html__( 'Site Key', 'spirit' ),
				'id'   => 'recaptcha_site_key',
				'size' => 60,
			],
			[
				'type' => 'text',
				'name' => esc_html__( 'Secret Key', 'spirit' ),
				'id'   => 'recaptcha_secret_key',
				'size' => 60,
			],
			[
				'type'    => 'select',
				'name'    => esc_html__( 'Script Source', 'spirit' ),
				'id'      => 'recaptcha_source',
				'desc'    => esc_html__( 'Please use "www.recaptcha.net" in circumstances when "www.google.com" is not accessible.', 'spirit' ),
				'options' => [
					'google.com'    => 'google.com',
					'recaptcha.net' => 'recaptcha.net',
				],
				'std'     => $default_settings['recaptcha_source'],
			],
			[
				'type'    => 'select',
				'name'    => esc_html__( 'Version', 'spirit' ),
				'id'      => 'recaptcha_version',
				'options' => [
					'3' => esc_html__( 'v3', 'spirit' ),
					'2' => esc_html__( 'v2', 'spirit' ),
				],
				'std'     => $default_settings['recaptcha_version'],
			],
			[
				'id'      => 'recaptcha_v3_threshold',
				'name'    => esc_html__( 'Score Threshold', 'spirit' ),
				'type'    => 'number',
				'desc'    => esc_html__( 'Score threshold should be a value between 0 and 1, default: 0.5', 'spirit' ),
				'min'     => 0,
				'max'     => 1,
				'step'    => 0.1,
				'std'     => '0.5',
				'visible' => ['recaptcha_version', '=', '3'],
			],
		],
	];

	return $meta_boxes;
} );
