<?php
/**
 * SF Admin
 *
 */
defined( 'ABSPATH' ) || exit; // Exit if accessed directly.

class SF_Admin {

	/**
	 * Constructor
	 */
	function __construct() {
		$this->constants();
		$this->includes();
		$this->hooks();
	}

	/**
	 * Constants
	 */
	function constants() {
		if ( ! defined( 'SF_ADMIN_DIR' ) ) {
			define( 'SF_ADMIN_DIR', SF_FRAMEWORK_DIR . 'includes/admin/' );
		}
	}

	/**
	 * Include required files
	 */
	function includes() {
		require_once SF_FRAMEWORK_DIR . 'includes/libs/meta-box/meta-box.php';
		require_once SF_FRAMEWORK_DIR . 'includes/libs/mb-term-meta/mb-term-meta.php';
		require_once SF_FRAMEWORK_DIR . 'includes/libs/mb-user-meta/mb-user-meta.php';
		require_once SF_FRAMEWORK_DIR . 'includes/libs/meta-box-group/meta-box-group.php';
		require_once SF_FRAMEWORK_DIR . 'includes/libs/meta-box-conditional-logic/meta-box-conditional-logic.php';
		require_once SF_FRAMEWORK_DIR . 'includes/libs/meta-box-tabs/meta-box-tabs.php';
		require_once SF_FRAMEWORK_DIR . 'includes/libs/mb-settings-page/mb-settings-page.php';
		require_once SF_FRAMEWORK_DIR . 'includes/libs/pand.php';
		require_once SF_FRAMEWORK_DIR . 'includes/class-sf-plugins-manager.php';
		require_once SF_FRAMEWORK_DIR . 'includes/class-sf-theme-manager.php';
		require_once SF_FRAMEWORK_DIR . 'includes/demo/class-sf-demo-manager.php';
		require_once SF_FRAMEWORK_DIR . 'includes/fonts/class-sf-fonts-manager.php';
		require_once SF_FRAMEWORK_DIR . 'includes/menu/class-sf-megamenu.php';
		require_once SF_FRAMEWORK_DIR . 'includes/class-sf-widget.php';
		require_once SF_FRAMEWORK_DIR . 'includes/custom/usermeta.php';
		require_once SF_FRAMEWORK_DIR . 'includes/class-sf-product-registration.php';
		require_once SF_FRAMEWORK_DIR . 'includes/class-sf-product-updater.php';
		require_once SF_ADMIN_DIR . 'settings/settings.php';
	}

	/**
	 * Hooks
	 */
	function hooks() {
		add_action( 'after_switch_theme', [ $this, 'plugin_default' ], 99 );
		add_action( 'admin_enqueue_scripts', [ $this, 'admin_scripts' ] );
		add_action( 'admin_bar_menu', [ $this, 'adminbar_support' ], 999 );
		add_action( 'admin_menu', [ $this, 'admin_menus' ] );
		add_action( 'in_admin_header', [ $this, 'admin_notices' ], 900 );
		add_action( 'admin_head', [ $this, 'admin_fonts' ] );
		add_action( 'customize_controls_print_scripts', [ $this, 'admin_fonts' ] );
		add_action( 'init', [ $this, 'mb_icon_type' ] );
		add_action( 'wp_ajax_sf_product_registration', [ sf_product_registration(), 'handle_product_registration' ] );
	}

	/**
	 * Admin menus
	 */
	function admin_menus() {
		if ( current_user_can( 'edit_theme_options' ) ) {

			$admin_submenus = [
				'dashboard'      => esc_html__( 'Dashboard', 'spirit' ),
				'demos'        => esc_html__( 'Demos', 'spirit' ),
				'fonts'        => esc_html__( 'Fonts', 'spirit' ),
				'status'       => esc_html__( 'Status', 'spirit' ),
			];

			$admin_submenus = apply_filters( 'sf_admin_submenu_items', $admin_submenus );

			// add top menu
			$theme_data = SF_Theme_Manager::get_theme();
			$theme_name = $theme_data['name'];
			add_menu_page( $theme_name, $theme_name, 'edit_theme_options', 'sf_dashboard', function () {
				include_once SF_ADMIN_DIR . 'views/header.php';
				include_once SF_ADMIN_DIR . 'views/dashboard.php';
				include_once SF_ADMIN_DIR . 'views/footer.php';
			}, null, 2 );

			// add sub menus
			foreach ( $admin_submenus as $menu_slug => $menu_title ) {

				$page_title = apply_filters( 'sf_admin_page_title', $menu_title, $menu_slug ); 
				$menu_title = apply_filters( 'sf_admin_menu_title', $menu_title, $menu_slug );

				add_submenu_page( 'sf_dashboard', $page_title, $menu_title, 'edit_theme_options', 'sf_' . $menu_slug, function () use ( $menu_slug ) {
					include_once SF_ADMIN_DIR . 'views/header.php';
					include_once SF_ADMIN_DIR . 'views/' . $menu_slug . '.php';
					include_once SF_ADMIN_DIR . 'views/footer.php';
				} );
			}
		}
	}

	/**
	 * Add to admin bar
	 * @param  object $wp_admin_bar wp admin bar
	 */
	function adminbar_support( $wp_admin_bar ) {
		$wp_admin_bar->add_node(
			[
				'id'    => 'theme-spirit',
				'title' => 'Theme Support',
				'href'  => 'https://themespirit.com/support',
				'meta'  => [ 'target' => '_blank' ],
			] );
	}

	/**
	 * Show admin notices
	 */
	function admin_notices() {
		$current_page    = isset( $_GET['page'] ) ? $_GET['page'] : '';
		$dashboard_pages = [
			'sf_dashboard',
			'sf_fonts',
			'sf_status',
			'sf_demos',
			'sf_plugins',
		];
		if ( in_array( $current_page, $dashboard_pages ) ) {
			remove_all_actions( 'admin_notices' );
			remove_all_actions( 'all_admin_notices' );
		}
	}

	/**
	 * Enqueue admin scripts
	 */
	function admin_scripts() {
		$suffix = defined( 'SF_SCRIPT_DEBUG' ) && SF_SCRIPT_DEBUG ? '' : '.min';

		// Enqueue styles
		wp_register_style( 'font-awesome-5-all', SF_FRAMEWORK_URI . 'assets/lib/font-awesome/css/all.min.css', [], '5.15.1' );
		wp_register_style( 'sf-bootstrap-modal', SF_FRAMEWORK_URI . 'assets/lib/bootstrap/css/bootstrap-modal' . $suffix . '.css' );

		wp_enqueue_style( 'sf-admin', SF_FRAMEWORK_URI . 'assets/css/admin' . $suffix . '.css', false, SF_FRAMEWORK_VERSION );
		wp_style_add_data( 'sf-admin', 'rtl', 'replace' );

		// Register admin scripts
		wp_register_script( 'jquery-tiptip', SF_FRAMEWORK_URI . 'assets/lib/tiptip/jquery.tipTip.min.js', [ 'jquery' ], SF_FRAMEWORK_VERSION, true );

		wp_register_script( 'fonticonpicker', SF_FRAMEWORK_URI . 'assets/lib/fonticonpicker/js/jquery.fonticonpicker.min.js', [ 'jquery' ], SF_FRAMEWORK_VERSION, true );

		wp_register_script( 'sf-bootstrap-modal', SF_FRAMEWORK_URI . 'assets/lib/bootstrap/js/bootstrap.modal' . $suffix . '.js', [ 'jquery' ], SF_FRAMEWORK_VERSION, true );

		wp_register_script( 'sf-fonts', SF_FRAMEWORK_URI . 'assets/js/admin/fonts' . $suffix . '.js', [ 'jquery' ], SF_FRAMEWORK_VERSION, true );

		wp_register_script( 'sf-system-status', SF_FRAMEWORK_URI . 'assets/js/admin/system-status' . $suffix . '.js', [ 'jquery', 'jquery-tiptip' ], SF_FRAMEWORK_VERSION, true );

		wp_register_script( 'sf-megamenu', SF_FRAMEWORK_URI . 'assets/js/admin/megamenu' . $suffix . '.js', [ 'jquery', 'sf-bootstrap-modal', 'fonticonpicker' ], SF_FRAMEWORK_VERSION, true );

		wp_register_script( 'sf-admin', SF_FRAMEWORK_URI . 'assets/js/admin/admin' . $suffix . '.js', [ 'jquery', 'imagesloaded', 'jquery-tiptip', 'fonticonpicker' ], SF_FRAMEWORK_VERSION, true );

		// Enqueue scripts
		wp_enqueue_script( 'imagesloaded' );

		$current_page   = isset( $_GET['page'] ) ? $_GET['page'] : '';
		$current_screen = get_current_screen();

		if ( 'sf_demos' === $current_page || 'sf_plugins' === $current_page ) {
			wp_enqueue_style( 'sf-bootstrap-modal' );
			wp_enqueue_script( 'sf-bootstrap-modal' );
		}

		if ( 'sf_fonts' === $current_page ) {
			wp_enqueue_script( 'sf-fonts' );
		}

		if ( 'sf_status' === $current_page ) {
			wp_enqueue_script( 'sf-system-status' );
		}

		if ( 'nav-menus' === $current_screen->id ) {
			wp_enqueue_style( 'wp-color-picker' );
			wp_enqueue_script( 'wp-color-picker-alpha', SF_FRAMEWORK_URI . 'assets/lib/colorpicker/wp-color-picker-alpha.min.js', [ 'wp-color-picker' ], SF_FRAMEWORK_VERSION, true );
			wp_enqueue_media();
			wp_enqueue_style( 'font-awesome-5-all' );
			wp_enqueue_style( 'sf-bootstrap-modal' );
			wp_enqueue_script( 'sf-megamenu' );
		}

		if ( 'widgets' === $current_screen->id ) {
			wp_enqueue_style( 'select2' );
			wp_enqueue_script( 'select2' );
			wp_enqueue_style( 'font-awesome-5-all' );
		}

		if ( is_customize_preview() ) {
			wp_enqueue_style( 'select2' );
			wp_enqueue_script( 'select2' );
		}

		wp_enqueue_script( 'sf-admin' );
		wp_localize_script( 'sf-admin', 'SF_L10n', self::l10n() );
	}

	/**
	 * Returns translation strings.
	 *
	 * @return array
	 */
	public static function l10n() {
		return [
			'remove_sidebar'           => __( 'Are you sure to remove this sidebar?', 'spirit' ),
			'install_required_plugins' => __( 'Please install all the required plugins.', 'spirit' ),
			'install_demo'             => __( "Demo Installation\n\nThis will replicate the live demo, which include all the demo content and theme settings being selected. Your current theme settings will be overwritten. Installation could take a minute or less to complete.\n\nDo you want to proceed?", 'spirit' ),
			'uninstall_demo'           => __( "All demo content and settings will be deleted. Contents created prior to demo installation will not be touched.\n\nDo you want to procceed?", 'spirit' ),
			'user_confirmation'        => __( 'Are you sure?', 'spirit' ),
			'user_approve'             => __( 'Approve now', 'spirit' ),
			'user_remove_approval'     => __( 'Remove Approval', 'spirit' ),
			'user_updating'            => __( 'Updating user', 'spirit' ),
			'user_updating'            => __( 'Updating user', 'spirit' ),
			'theme_updating'    	   => __( 'Updating the theme&#8230;', 'spirit' ),
			'theme_update_success'     => __( 'Theme updated!', 'spirit' ),
			'theme_update_fail'        => __( 'Theme update failed.', 'spirit' ),
			'theme_install_fail'       => __( 'Theme install failed.', 'spirit' ),
			'child_theme_installed'    => __( 'Child theme installed!', 'spirit' ),
		];
	}

	/**
	 * Fonts
	 */
	function admin_fonts() {
		?>
        <script type="text/javascript">
            var SF_Fonts = <?php echo json_encode( sf_get_font_icons() ); ?>
        </script><?php
    }

	/**
	 * Metabox Icon field
	 */
	function mb_icon_type() {
		require SF_FRAMEWORK_DIR . 'includes/fields/icon.php';
	}

	/**
	 * Add default
	 */
	function plugin_default() {
		// install default fonts
		SF_Fonts::add_default_fonts();
	}
}