/**
 *  jQuery fontIconPicker - 3.1.1
 *
 *  An icon picker built on top of font icons and jQuery
 *
 *  http://codeb.it/fontIconPicker
 *
 *  @author Alessandro Benoit & Swashata Ghosh
 *  @license MIT License
 *
 * {@link https://github.com/micc83/fontIconPicker}
 */
(function(global,factory){typeof exports==='object'&&typeof module!=='undefined'?module.exports=factory(require('jquery')):typeof define==='function'&&define.amd?define(['jquery'],factory):(global.initFontIconPickerNode=factory(global.jQuery))}(this,(function(jQuery){'use strict';jQuery=jQuery&&jQuery.hasOwnProperty('default')?jQuery['default']:jQuery;function _typeof(obj){if(typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"){_typeof=function(obj){return typeof obj}}else{_typeof=function(obj){return obj&&typeof Symbol==="function"&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj}}return _typeof(obj)}function _toConsumableArray(arr){return _arrayWithoutHoles(arr)||_iterableToArray(arr)||_nonIterableSpread()}function _arrayWithoutHoles(arr){if(Array.isArray(arr)){for(var i=0,arr2=[arr.length];i<arr.length;i+=1){arr2[i]=arr[i]}return arr2}}function _iterableToArray(iter){if(Symbol.iterator in Object(iter)||Object.prototype.toString.call(iter)==="[object Arguments]"){return Array.from(iter)}}function _nonIterableSpread(){throw new TypeError("Invalid attempt to spread non-iterable instance")}var options={theme:'fip-grey',source:false,emptyIcon:true,emptyIconValue:'',autoClose:true,iconsPerPage:20,hasSearch:true,searchSource:false,appendTo:'self',useAttribute:false,attributeName:'data-icon',convertToHex:true,allCategoryText:'From all categories',unCategorizedText:'Uncategorized',iconGenerator:null,windowDebounceDelay:150,searchPlaceholder:'Search Icons'};var debounce=function debounce(func,delay){var inDebounce;return function(){var context=this;var args=arguments;clearTimeout(inDebounce);inDebounce=setTimeout(function(){return func.apply(context,args)},delay)}};var $=jQuery;var guid=0;function FontIconPicker(element,options$$1){this.element=$(element);this.settings=$.extend({},options,options$$1);if(this.settings.emptyIcon){this.settings.iconsPerPage-=1}this.iconPicker=$('<div/>',{class:'icons-selector',style:'position: relative',html:this._getPickerTemplate(),attr:{'data-fip-origin':this.element.attr('id')}});this.iconContainer=this.iconPicker.find('.fip-icons-container');this.searchIcon=this.iconPicker.find('.selector-search i');this.selectorPopup=this.iconPicker.find('.selector-popup-wrap');this.selectorButton=this.iconPicker.find('.selector-button');this.iconsSearched=[];this.isSearch=false;this.totalPage=1;this.currentPage=1;this.currentIcon=false;this.iconsCount=0;this.open=false;this.guid=guid++;this.eventNameSpace=".fontIconPicker".concat(guid);this.searchValues=[];this.availableCategoriesSearch=[];this.triggerEvent=null;this.backupSource=[];this.backupSearch=[];this.isCategorized=false;this.selectCategory=this.iconPicker.find('.icon-category-select');this.selectedCategory=false;this.availableCategories=[];this.unCategorizedKey=null;this.init()}FontIconPicker.prototype={init:function init(){this.iconPicker.addClass(this.settings.theme);this.iconPicker.css({left:-9999}).appendTo('body');var iconPickerHeight=this.iconPicker.outerHeight(),iconPickerWidth=this.iconPicker.outerWidth();this.iconPicker.css({left:''});this.element.before(this.iconPicker);this.element.css({visibility:'hidden',top:0,position:'relative',zIndex:'-1',left:'-'+iconPickerWidth+'px',display:'inline-block',height:iconPickerHeight+'px',width:iconPickerWidth+'px',padding:'0',margin:'0 -'+iconPickerWidth+'px 0 0',border:'0 none',verticalAlign:'top',float:'none'});if(!this.element.is('select')){this.triggerEvent='input'}if(!this.settings.source&&this.element.is('select')){this._populateSourceFromSelect();}else{this._initSourceIndex()}this._loadCategories();this._loadIcons();this._initDropDown();this._initCategoryChanger();this._initPagination();this._initIconSearch();this._initIconSelect();this._initAutoClose();this._initFixOnResize()},setIcons:function setIcons(newIcons,iconSearch){this.settings.source=Array.isArray(newIcons)?_toConsumableArray(newIcons):$.extend({},newIcons);this.settings.searchSource=Array.isArray(iconSearch)?_toConsumableArray(iconSearch):$.extend({},iconSearch);this._initSourceIndex();this._loadCategories();this._resetSearch();this._loadIcons()},setIcon:function setIcon(){var theIcon=arguments.length>0&&arguments[0]!==undefined?arguments[0]:'';this._setSelectedIcon(theIcon)},destroy:function destroy(){this.iconPicker.off().remove();this.element.css({visibility:'',top:'',position:'',zIndex:'',left:'',display:'',height:'',width:'',padding:'',margin:'',border:'',verticalAlign:'',float:''});$(window).off('resize'+this.eventNameSpace);$('html').off('click'+this.eventNameSpace)},resetPosition:function resetPosition(){this._fixOnResize()},setPage:function setPage(pageNum){if('first'==pageNum){pageNum=1}if('last'==pageNum){pageNum=this.totalPage}pageNum=parseInt(pageNum,10);if(isNaN(pageNum)){pageNum=1}if(pageNum>this.totalPage){pageNum=this.totalPage}if(1>pageNum){pageNum=1}this.currentPage=pageNum;this._renderIconContainer()},_initFixOnResize:function _initFixOnResize(){var _this=this;$(window).on('resize'+this.eventNameSpace,debounce(function(){_this._fixOnResize()},this.settings.windowDebounceDelay))},_initAutoClose:function _initAutoClose(){var _this2=this;if(this.settings.autoClose){$('html').on('click'+this.eventNameSpace,function(event){var target=event.target;if(_this2.selectorPopup.has(target).length||_this2.selectorPopup.is(target)||_this2.iconPicker.has(target).length||_this2.iconPicker.is(target)){return}if(_this2.open){_this2._toggleIconSelector()}})}},_initIconSelect:function _initIconSelect(){var _this3=this;this.selectorPopup.on('click','.fip-box',function(e){var fipBox=$(e.currentTarget);_this3._setSelectedIcon(fipBox.attr('data-fip-value'));_this3._toggleIconSelector()})},_initIconSearch:function _initIconSearch(){var _this4=this;this.selectorPopup.on('input','.icons-search-input',function(e){var searchString=$(e.currentTarget).val();if(''===searchString){_this4._resetSearch();return}_this4.searchIcon.removeClass('fip-icon-search');_this4.searchIcon.addClass('fip-icon-cancel');_this4.isSearch=true;_this4.currentPage=1;_this4.iconsSearched=[];$.grep(_this4.searchValues,function(n,i){if(0<=n.toLowerCase().search(searchString.toLowerCase())){_this4.iconsSearched[_this4.iconsSearched.length]=_this4.settings.source[i];return true}});_this4._renderIconContainer()});this.selectorPopup.on('click','.selector-search .fip-icon-cancel',function(){_this4.selectorPopup.find('.icons-search-input').focus();_this4._resetSearch()})},_initPagination:function _initPagination(){var _this5=this;this.selectorPopup.on('click','.selector-arrow-right',function(e){if(_this5.currentPage<_this5.totalPage){_this5.currentPage=_this5.currentPage+1;_this5._renderIconContainer()}});this.selectorPopup.on('click','.selector-arrow-left',function(e){if(1<_this5.currentPage){_this5.currentPage=_this5.currentPage-1;_this5._renderIconContainer()}})},_initCategoryChanger:function _initCategoryChanger(){var _this6=this;this.selectorPopup.on('change keyup','.icon-category-select',function(e){if(false===_this6.isCategorized){return false}var targetSelect=$(e.currentTarget),currentCategory=targetSelect.val();if('all'===targetSelect.val()){_this6.settings.source=_this6.backupSource;_this6.searchValues=_this6.backupSearch;}else{var key=parseInt(currentCategory,10);if(_this6.availableCategories[key]){_this6.settings.source=_this6.availableCategories[key];_this6.searchValues=_this6.availableCategoriesSearch[key]}}_this6._resetSearch();_this6._loadIcons()})},_initDropDown:function _initDropDown(){var _this7=this;this.selectorButton.on('click',function(event){_this7._toggleIconSelector()})},_getPickerTemplate:function _getPickerTemplate(){var pickerTemplate="\n<div class=\"selector\" data-fip-origin=\"".concat(this.element.attr('id'),"\">\n\t<span class=\"selected-icon\">\n\t\t<i class=\"fip-icon-block\"></i>\n\t</span>\n\t<span class=\"selector-button\">\n\t\t<i class=\"fip-icon-down-dir\"></i>\n\t</span>\n</div>\n<div class=\"selector-popup-wrap\" data-fip-origin=\"").concat(this.element.attr('id'),"\">\n\t<div class=\"selector-popup\" style=\"display: none;\"> ").concat(this.settings.hasSearch?"<div class=\"selector-search\">\n\t\t\t<input type=\"text\" name=\"\" value=\"\" placeholder=\"".concat(this.settings.searchPlaceholder,"\" class=\"icons-search-input\"/>\n\t\t\t<i class=\"fip-icon-search\"></i>\n\t\t</div>"):'',"\n\t\t<div class=\"selector-category\">\n\t\t\t<select name=\"\" class=\"icon-category-select\" style=\"display: none\"></select>\n\t\t</div>\n\t\t<div class=\"fip-icons-container\"></div>\n\t\t<div class=\"selector-footer\" style=\"display:none;\">\n\t\t\t<span class=\"selector-pages\">1/2</span>\n\t\t\t<span class=\"selector-arrows\">\n\t\t\t\t<span class=\"selector-arrow-left\" style=\"display:none;\">\n\t\t\t\t\t<i class=\"fip-icon-left-dir\"></i>\n\t\t\t\t</span>\n\t\t\t\t<span class=\"selector-arrow-right\">\n\t\t\t\t\t<i class=\"fip-icon-right-dir\"></i>\n\t\t\t\t</span>\n\t\t\t</span>\n\t\t</div>\n\t</div>\n</div>");return pickerTemplate},_initSourceIndex:function _initSourceIndex(){if('object'!==_typeof(this.settings.source)){return}if(Array.isArray(this.settings.source)){this.isCategorized=false;this.selectCategory.html('').hide();this.settings.source=$.map(this.settings.source,function(e,i){if('function'==typeof e.toString){return e.toString()}else{return e}});if(Array.isArray(this.settings.searchSource)){this.searchValues=$.map(this.settings.searchSource,function(e,i){if('function'==typeof e.toString){return e.toString()}else{return e}});}else{this.searchValues=this.settings.source.slice(0);}}else{var originalSource=$.extend(true,{},this.settings.source);this.settings.source=[];this.searchValues=[];this.availableCategoriesSearch=[];this.selectedCategory=false;this.availableCategories=[];this.unCategorizedKey=null;this.isCategorized=true;this.selectCategory.html('');for(var categoryLabel in originalSource){var thisCategoryKey=this.availableCategories.length,categoryOption=$('<option />');categoryOption.attr('value',thisCategoryKey);categoryOption.html(categoryLabel);this.selectCategory.append(categoryOption);this.availableCategories[thisCategoryKey]=[];this.availableCategoriesSearch[thisCategoryKey]=[];for(var newIconKey in originalSource[categoryLabel]){var newIconValue=originalSource[categoryLabel][newIconKey];var newIconLabel=this.settings.searchSource&&this.settings.searchSource[categoryLabel]&&this.settings.searchSource[categoryLabel][newIconKey]?this.settings.searchSource[categoryLabel][newIconKey]:newIconValue;if('function'==typeof newIconValue.toString){newIconValue=newIconValue.toString()}if(newIconValue&&newIconValue!==this.settings.emptyIconValue){this.settings.source.push(newIconValue);this.availableCategories[thisCategoryKey].push(newIconValue);this.searchValues.push(newIconLabel);this.availableCategoriesSearch[thisCategoryKey].push(newIconLabel)}}}}this.backupSource=this.settings.source.slice(0);this.backupSearch=this.searchValues.slice(0)},_populateSourceFromSelect:function _populateSourceFromSelect(){var _this8=this;this.settings.source=[];this.settings.searchSource=[];if(this.element.find('optgroup').length){this.isCategorized=true;this.element.find('optgroup').each(function(i,el){var thisCategoryKey=_this8.availableCategories.length,categoryOption=$('<option />');categoryOption.attr('value',thisCategoryKey);categoryOption.html($(el).attr('label'));_this8.selectCategory.append(categoryOption);_this8.availableCategories[thisCategoryKey]=[];_this8.availableCategoriesSearch[thisCategoryKey]=[];$(el).find('option').each(function(i,cel){var newIconValue=$(cel).val(),newIconLabel=$(cel).html();if(newIconValue&&newIconValue!==_this8.settings.emptyIconValue){_this8.settings.source.push(newIconValue);_this8.availableCategories[thisCategoryKey].push(newIconValue);_this8.searchValues.push(newIconLabel);_this8.availableCategoriesSearch[thisCategoryKey].push(newIconLabel)}})});if(this.element.find('> option').length){this.element.find('> option').each(function(i,el){var newIconValue=$(el).val(),newIconLabel=$(el).html();if(!newIconValue||''===newIconValue||newIconValue==_this8.settings.emptyIconValue){return true}if(null===_this8.unCategorizedKey){_this8.unCategorizedKey=_this8.availableCategories.length;_this8.availableCategories[_this8.unCategorizedKey]=[];_this8.availableCategoriesSearch[_this8.unCategorizedKey]=[];$('<option />').attr('value',_this8.unCategorizedKey).html(_this8.settings.unCategorizedText).appendTo(_this8.selectCategory)}_this8.settings.source.push(newIconValue);_this8.availableCategories[_this8.unCategorizedKey].push(newIconValue);_this8.searchValues.push(newIconLabel);_this8.availableCategoriesSearch[_this8.unCategorizedKey].push(newIconLabel)})}}else{this.element.find('option').each(function(i,el){var newIconValue=$(el).val(),newIconLabel=$(el).html();if(newIconValue){_this8.settings.source.push(newIconValue);_this8.searchValues.push(newIconLabel)}})}this.backupSource=this.settings.source.slice(0);this.backupSearch=this.searchValues.slice(0)},_loadCategories:function _loadCategories(){if(false===this.isCategorized){return}$('<option value="all">'+this.settings.allCategoryText+'</option>').prependTo(this.selectCategory);this.selectCategory.show().val('all').trigger('change')},_loadIcons:function _loadIcons(){this.iconContainer.html('<i class="fip-icon-spin3 animate-spin loading"></i>');if(Array.isArray(this.settings.source)){this._renderIconContainer()}},_iconGenerator:function _iconGenerator(icon){if('function'===typeof this.settings.iconGenerator){return this.settings.iconGenerator(icon)}return '<i '+(this.settings.useAttribute?this.settings.attributeName+'="'+(this.settings.convertToHex?'&#x'+parseInt(icon,10).toString(16)+';':icon)+'"':'class="'+icon+'"')+'></i>'},_renderIconContainer:function _renderIconContainer(){var _this9=this;var offset,iconsPaged=[];if(this.isSearch){iconsPaged=this.iconsSearched}else{iconsPaged=this.settings.source}this.iconsCount=iconsPaged.length;this.totalPage=Math.ceil(this.iconsCount/this.settings.iconsPerPage);if(1<this.totalPage){this.selectorPopup.find('.selector-footer').show();if(this.currentPage<this.totalPage){this.selectorPopup.find('.selector-arrow-right').show()}else{this.selectorPopup.find('.selector-arrow-right').hide()}if(1<this.currentPage){this.selectorPopup.find('.selector-arrow-left').show()}else{this.selectorPopup.find('.selector-arrow-left').hide()}}else{this.selectorPopup.find('.selector-footer').hide()}this.selectorPopup.find('.selector-pages').html(this.currentPage+'/'+this.totalPage+' <em>('+this.iconsCount+')</em>');offset=(this.currentPage-1)*this.settings.iconsPerPage;if(this.settings.emptyIcon){this.iconContainer.html('<span class="fip-box" data-fip-value="fip-icon-block"><i class="fip-icon-block"></i></span>');}else if(1>iconsPaged.length){this.iconContainer.html('<span class="icons-picker-error" data-fip-value="fip-icon-block"><i class="fip-icon-block"></i></span>');return;}else{this.iconContainer.html('')}iconsPaged=iconsPaged.slice(offset,offset+this.settings.iconsPerPage);var _loop=function _loop(i,icon){var fipBoxTitle=icon;$.grep(_this9.settings.source,$.proxy(function(e,i){if(e===icon){fipBoxTitle=this.searchValues[i];return true}return false},_this9));$('<span/>',{html:_this9._iconGenerator(icon),attr:{'data-fip-value':icon},class:'fip-box',title:fipBoxTitle}).appendTo(_this9.iconContainer)};for(var i=0,icon;icon=iconsPaged[i++];){_loop(i,icon)}if(!this.settings.emptyIcon&&(!this.element.val()||-1===$.inArray(this.element.val(),this.settings.source))){this._setSelectedIcon(iconsPaged[0])}else if(-1===$.inArray(this.element.val(),this.settings.source)){this._setSelectedIcon('')}else{var passDefaultIcon=this.element.val();if(passDefaultIcon===this.settings.emptyIconValue){passDefaultIcon='fip-icon-block'}this._setSelectedIcon(passDefaultIcon)}},_setHighlightedIcon:function _setHighlightedIcon(){this.iconContainer.find('.current-icon').removeClass('current-icon');if(this.currentIcon){this.iconContainer.find('[data-fip-value="'+this.currentIcon+'"]').addClass('current-icon')}},_setSelectedIcon:function _setSelectedIcon(theIcon){if('fip-icon-block'===theIcon){theIcon=''}var selectedIcon=this.iconPicker.find('.selected-icon');if(''===theIcon){selectedIcon.html('<i class="fip-icon-block"></i>')}else{selectedIcon.html(this._iconGenerator(theIcon))}var currentValue=this.element.val();this.element.val(''===theIcon?this.settings.emptyIconValue:theIcon);if(currentValue!==theIcon){this.element.trigger('change');if(null!==this.triggerEvent){this.element.trigger(this.triggerEvent)}}this.currentIcon=theIcon;this._setHighlightedIcon()},_repositionIconSelector:function _repositionIconSelector(){var offset=this.iconPicker.offset(),offsetTop=offset.top+this.iconPicker.outerHeight(true)-$(window).scrollTop(),offsetLeft=offset.left;this.selectorPopup.css({left:offsetLeft,top:offsetTop})},_fixWindowOverflow:function _fixWindowOverflow(){var visibilityStatus=this.selectorPopup.find('.selector-popup').is(':visible');if(!visibilityStatus){this.selectorPopup.find('.selector-popup').show()}var popupWidth=this.selectorPopup.outerWidth(),windowWidth=$(window).width(),popupOffsetLeft=this.selectorPopup.offset().left,containerOffset='self'==this.settings.appendTo?this.selectorPopup.parent().offset():$(this.settings.appendTo).offset();if(!visibilityStatus){this.selectorPopup.find('.selector-popup').hide()}if(popupOffsetLeft+popupWidth>windowWidth-20){var pickerOffsetRight=this.selectorButton.offset().left+this.selectorButton.outerWidth();var preferredLeft=Math.floor(pickerOffsetRight-popupWidth-1);if(0>preferredLeft){this.selectorPopup.css({left:windowWidth-20-popupWidth-containerOffset.left})}else{this.selectorPopup.css({left:preferredLeft})}}},_fixOnResize:function _fixOnResize(){if('self'!==this.settings.appendTo){this._repositionIconSelector()}this._fixWindowOverflow()},_toggleIconSelector:function _toggleIconSelector(){this.open=!this.open?1:0;if(this.open){if('self'!==this.settings.appendTo){this.selectorPopup.appendTo(this.settings.appendTo).css({zIndex:1000}).addClass('icons-selector '+this.settings.theme);this._repositionIconSelector()}this._fixWindowOverflow()}this.selectorPopup.find('.selector-popup').slideToggle(300,$.proxy(function(){this.iconPicker.find('.selector-button i').toggleClass('fip-icon-down-dir');this.iconPicker.find('.selector-button i').toggleClass('fip-icon-up-dir');if(this.open){this.selectorPopup.find('.icons-search-input').trigger('focus').trigger('select')}else{this.selectorPopup.appendTo(this.iconPicker).css({left:'',top:'',zIndex:''}).removeClass('icons-selector '+this.settings.theme)}},this))},_resetSearch:function _resetSearch(){this.selectorPopup.find('.icons-search-input').val('');this.searchIcon.removeClass('fip-icon-cancel');this.searchIcon.addClass('fip-icon-search');this.currentPage=1;this.isSearch=false;this._renderIconContainer()}};function fontIconPickerShim($){if(!$.fn){return false}if($.fn&&$.fn.fontIconPicker){return true}$.fn.fontIconPicker=function(options){var _this=this;this.each(function(){if(!$.data(this,'fontIconPicker')){$.data(this,'fontIconPicker',new FontIconPicker(this,options))}});this.setIcons=function(){var newIcons=arguments.length>0&&arguments[0]!==undefined?arguments[0]:false;var iconSearch=arguments.length>1&&arguments[1]!==undefined?arguments[1]:false;_this.each(function(){$.data(this,'fontIconPicker').setIcons(newIcons,iconSearch)})};this.setIcon=function(){var newIcon=arguments.length>0&&arguments[0]!==undefined?arguments[0]:'';_this.each(function(){$.data(this,'fontIconPicker').setIcon(newIcon)})};this.destroyPicker=function(){_this.each(function(){if(!$.data(this,'fontIconPicker')){return}$.data(this,'fontIconPicker').destroy();$.removeData(this,'fontIconPicker')})};this.refreshPicker=function(newOptions){if(!newOptions){newOptions=options}_this.destroyPicker();_this.each(function(){if(!$.data(this,'fontIconPicker')){$.data(this,'fontIconPicker',new FontIconPicker(this,newOptions))}})};this.repositionPicker=function(){_this.each(function(){$.data(this,'fontIconPicker').resetPosition()})};this.setPage=function(pageNum){_this.each(function(){$.data(this,'fontIconPicker').setPage(pageNum)})};return this};return true}function initFontIconPicker(jQuery$$1){return fontIconPickerShim(jQuery$$1)}if(jQuery&&jQuery.fn){initFontIconPicker(jQuery)}var jquery_fonticonpicker=(function(jQuery$$1){return initFontIconPicker(jQuery$$1)});return jquery_fonticonpicker})));